/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.user.api.resource;

import io.muenchendigital.digiwf.legacy.user.api.mapper.UserTOMapper;
import io.muenchendigital.digiwf.legacy.user.api.transport.SearchUserTO;
import io.muenchendigital.digiwf.legacy.user.api.transport.UserTO;
import io.muenchendigital.digiwf.legacy.user.domain.model.User;
import io.muenchendigital.digiwf.legacy.user.domain.service.UserService;
import io.muenchendigital.digiwf.shared.security.AppAuthenticationProvider;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
@RequestMapping(value={"/rest/user"})
@Tag(name="UserRestController", description="API to get users")
public class UserRestController {
    private final UserService userService;
    private final AppAuthenticationProvider userAuthenticationProvider;
    private final UserTOMapper userMapper;

    @PostMapping(value={"/search"})
    public ResponseEntity<List<UserTO>> getUsers(@RequestBody SearchUserTO searchUserTO) {
        List users = this.userService.searchUser(searchUserTO.getSearchString(), searchUserTO.getOus());
        return ResponseEntity.ok((Object)this.userMapper.map2TO(users));
    }

    @GetMapping(value={"/info"})
    public ResponseEntity<UserTO> userinfo() {
        User user = this.userService.getUser(this.userAuthenticationProvider.getCurrentUserId());
        return ResponseEntity.ok((Object)((UserTO)this.userMapper.map2TO((Object)user)));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<UserTO> getUser(@PathVariable(value="id") String id) {
        User user = this.userService.getUser(id);
        return ResponseEntity.ok((Object)((UserTO)this.userMapper.map2TO((Object)user)));
    }

    @GetMapping(value={"/uid/{username}"})
    public ResponseEntity<UserTO> getUserByUsername(@PathVariable(value="username") String username) {
        User user = (User)this.userService.getUserByUserName(username).get();
        return ResponseEntity.ok((Object)((UserTO)this.userMapper.map2TO((Object)user)));
    }

    public UserRestController(UserService userService, AppAuthenticationProvider userAuthenticationProvider, UserTOMapper userMapper) {
        this.userService = userService;
        this.userAuthenticationProvider = userAuthenticationProvider;
        this.userMapper = userMapper;
    }
}

