/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.user.external.configuration;

import io.muenchendigital.digiwf.legacy.user.external.client.LhmLdapClient;
import io.muenchendigital.digiwf.legacy.user.external.client.query.LdapFilterFactory;
import io.muenchendigital.digiwf.legacy.user.external.client.query.LdapQueryFactory;
import io.muenchendigital.digiwf.legacy.user.external.configuration.ServiceAuthLdapProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.support.LdapContextSource;

@Configuration
public class LdapTemplateConfiguration {
    private final ServiceAuthLdapProperties serviceAuthLdapProperties;

    @Bean
    public LdapContextSource contextSourceTarget() {
        LdapContextSource ldapContextSource = new LdapContextSource();
        ldapContextSource.setUrl(this.serviceAuthLdapProperties.getContextSource());
        return ldapContextSource;
    }

    @Bean
    public LdapQueryFactory ldapQueryFactory(LdapFilterFactory ldapFilterFactory) {
        return new LdapQueryFactory(ldapFilterFactory, this.serviceAuthLdapProperties.getPersonSearchBase(), this.serviceAuthLdapProperties.getOuSearchBase());
    }

    @Bean
    public LhmLdapClient lhmLdapTemplate(LdapContextSource ldapContextSource, LdapQueryFactory ldapQueryFactory) {
        return new LhmLdapClient((ContextSource)this.contextSourceTarget(), ldapQueryFactory);
    }

    public LdapTemplateConfiguration(ServiceAuthLdapProperties serviceAuthLdapProperties) {
        this.serviceAuthLdapProperties = serviceAuthLdapProperties;
    }
}

