/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.process.config.api.resource;

import io.muenchendigital.digiwf.process.config.api.mapper.ProcessConfigApiMapper;
import io.muenchendigital.digiwf.process.config.api.transport.ProcessConfigTO;
import io.muenchendigital.digiwf.process.config.domain.model.ProcessConfig;
import io.muenchendigital.digiwf.process.config.domain.service.ProcessConfigService;
import io.muenchendigital.digiwf.shared.exception.ObjectNotFoundException;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@Transactional
@RequestMapping(value={"/rest/processconfig"})
@Tag(name="ProcessConfigurationController", description="API to interact with the process configuration")
public class ProcessConfigurationController {
    private final ProcessConfigService processConfigService;
    private final ProcessConfigApiMapper processConfigApiMapper;

    @PostMapping
    @PreAuthorize(value="hasAuthority(T(io.muenchendigital.digiwf.shared.security.AuthoritiesEnum).BACKEND_DEPLOY_RESOURCE.name())")
    public ResponseEntity<ProcessConfigTO> createConfig(@RequestBody @Valid ProcessConfigTO to) {
        ProcessConfig processConfig = this.processConfigService.saveProcessConfig(this.processConfigApiMapper.map(to));
        return ResponseEntity.ok((Object)this.processConfigApiMapper.map2TO(processConfig));
    }

    @GetMapping(value={"/{key}"})
    public ResponseEntity<ProcessConfigTO> getConfig(@PathVariable(value="key") @NotBlank String configKey) {
        ProcessConfig processConfig = (ProcessConfig)this.processConfigService.getProcessConfig(configKey).orElseThrow(() -> new ObjectNotFoundException("Config not available"));
        return ResponseEntity.ok((Object)this.processConfigApiMapper.map2TO(processConfig));
    }

    public ProcessConfigurationController(ProcessConfigService processConfigService, ProcessConfigApiMapper processConfigApiMapper) {
        this.processConfigService = processConfigService;
        this.processConfigApiMapper = processConfigApiMapper;
    }
}

