/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.process.config.api.streaming;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.muenchendigital.digiwf.asyncapi.docs.annotations.DocumentAsyncAPI;
import io.muenchendigital.digiwf.deployment.api.enums.DeploymentStatus;
import io.muenchendigital.digiwf.deployment.api.streaming.event.DeploymentEvent;
import io.muenchendigital.digiwf.deployment.domain.model.DeploymentStatusModel;
import io.muenchendigital.digiwf.process.config.api.mapper.ProcessConfigApiMapper;
import io.muenchendigital.digiwf.process.config.api.transport.ProcessConfigTO;
import io.muenchendigital.digiwf.process.config.domain.service.ProcessConfigService;
import java.io.IOException;
import java.util.Set;
import java.util.function.Consumer;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Sinks;

@Component
public class ConfigurationDeploymentEventListener {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationDeploymentEventListener.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
    private final ProcessConfigService processConfigService;
    private final ProcessConfigApiMapper processConfigApiMapper;
    private final Sinks.Many<Message<DeploymentStatusModel>> statusEmitter;

    @DocumentAsyncAPI(payload=DeploymentEvent.class, functionRouter=true, typeHeader="deployConfiguration")
    @Bean
    public Consumer<Message<DeploymentEvent>> deployConfiguration() {
        return message -> {
            DeploymentEvent deploymentEvent = (DeploymentEvent)message.getPayload();
            log.info("Sent deployment event with deploymentId: {}, versionId: {}, target: {}, artifactType: {}", new Object[]{deploymentEvent.getDeploymentId(), deploymentEvent.getVersionId(), deploymentEvent.getTarget(), deploymentEvent.getArtifactType()});
            try {
                ProcessConfigTO config = (ProcessConfigTO)this.objectMapper.readValue(deploymentEvent.getFile(), ProcessConfigTO.class);
                Set violations = this.validatorFactory.getValidator().validate((Object)config, new Class[0]);
                if (!violations.isEmpty()) {
                    throw new ConstraintViolationException(violations);
                }
                this.processConfigService.saveProcessConfig(this.processConfigApiMapper.map(config));
                Message statusMessage = MessageBuilder.withPayload((Object)new DeploymentStatusModel(DeploymentStatus.SUCCESSFUL.getValue(), deploymentEvent.getDeploymentId(), "Deployment was successful!")).build();
                this.statusEmitter.tryEmitNext((Object)statusMessage).orThrow();
                log.debug("Sent deployment status event for deployment {}", (Object)deploymentEvent.getDeploymentId());
            }
            catch (IOException | ConstraintViolationException e) {
                log.debug(e.getMessage(), e);
                Message statusMessage = MessageBuilder.withPayload((Object)new DeploymentStatusModel(DeploymentStatus.FAILURE.getValue(), deploymentEvent.getDeploymentId(), e.getMessage())).build();
                this.statusEmitter.tryEmitNext((Object)statusMessage).orThrow();
            }
        };
    }

    public ConfigurationDeploymentEventListener(ProcessConfigService processConfigService, ProcessConfigApiMapper processConfigApiMapper, Sinks.Many<Message<DeploymentStatusModel>> statusEmitter) {
        this.processConfigService = processConfigService;
        this.processConfigApiMapper = processConfigApiMapper;
        this.statusEmitter = statusEmitter;
    }
}

