/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.process.config.deployment;

import com.google.gson.Gson;
import io.muenchendigital.digiwf.process.config.api.mapper.ProcessConfigApiMapper;
import io.muenchendigital.digiwf.process.config.api.transport.ProcessConfigTO;
import io.muenchendigital.digiwf.process.config.domain.model.ProcessConfig;
import io.muenchendigital.digiwf.process.config.domain.service.ProcessConfigService;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.FileCopyUtils;

@Component
@ConditionalOnProperty(value={"digiwf.config.autodeploy"})
public class ProcessConfigAutodeploymentHandler {
    private static final Logger log = LoggerFactory.getLogger(ProcessConfigAutodeploymentHandler.class);
    private final ResourceLoader resourceLoader;
    private final ProcessConfigApiMapper processConfigMapper;
    private final ProcessConfigService processConfigService;

    @PostConstruct
    public void autoDeployForms() throws IOException {
        Resource[] resources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader).getResources("classpath:prozesse/**/*.processconfig.json");
        ArrayList<ProcessConfig> configs = new ArrayList<ProcessConfig>();
        for (Resource resource : resources) {
            try {
                ProcessConfig map = this.map(resource);
                configs.add(map);
            }
            catch (Exception error) {
                log.error("The config could no be loaded: {}", (Object)resource.getFilename(), (Object)error);
            }
        }
        for (ProcessConfig config : configs) {
            try {
                this.processConfigService.saveProcessConfig(config);
            }
            catch (Exception error) {
                log.error("The config could no be loaded: {}", (Object)config.getKey(), (Object)error);
            }
        }
    }

    private ProcessConfig map(Resource resource) throws IOException {
        String json = this.asString(resource);
        ProcessConfigTO to = (ProcessConfigTO)new Gson().fromJson(json, ProcessConfigTO.class);
        return this.processConfigMapper.map(to);
    }

    private String asString(Resource resource) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);){
            String string = FileCopyUtils.copyToString((Reader)reader);
            return string;
        }
    }

    public ProcessConfigAutodeploymentHandler(ResourceLoader resourceLoader, ProcessConfigApiMapper processConfigMapper, ProcessConfigService processConfigService) {
        this.resourceLoader = resourceLoader;
        this.processConfigMapper = processConfigMapper;
        this.processConfigService = processConfigService;
    }
}

