/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.process.config.domain.model;

import io.muenchendigital.digiwf.process.config.domain.model.ConfigEntry;
import io.muenchendigital.digiwf.process.config.domain.model.ProcessConfig;
import io.muenchendigital.digiwf.process.config.domain.model.StatusConfig;
import java.util.ArrayList;
import java.util.List;

public class ProcessConfig {
    public static final String INSTANCE_FILE_PATHS_READONLY = "app_instance_file_paths_readonly";
    public static final String INSTANCE_FILE_PATHS = "app_instance_file_paths";
    public static final String INSTANCE_SCHEMA_KEY = "app_instance_schema_key";
    private String key;
    private String statusDokument;
    private List<StatusConfig> statusConfig;
    private List<ConfigEntry> configs;

    public String getStatus(String statusKey) {
        return this.statusConfig.stream().filter(config -> statusKey.equals(config.getKey())).map(StatusConfig::getLabel).findAny().orElse(statusKey);
    }

    public String getConfig(String configKey) {
        return this.configs.stream().filter(obj -> configKey.equals(obj.getKey())).map(ConfigEntry::getValue).findFirst().orElse(null);
    }

    public boolean isIgnoreFieldsOnStart() {
        return "1".equals(this.getConfig("ignore_fields_on_start"));
    }

    public String getFilePathsReadonly() {
        return this.getConfig("app_file_paths_readonly");
    }

    public String getFilePaths() {
        return this.getConfig("app_file_paths");
    }

    public String getInstanceFilePathsReadonly() {
        return this.getConfig(INSTANCE_FILE_PATHS_READONLY);
    }

    public String getInstanceFilePaths() {
        return this.getConfig(INSTANCE_FILE_PATHS);
    }

    public String getInstanceSchemaKey() {
        return this.getConfig(INSTANCE_SCHEMA_KEY);
    }

    private static List<StatusConfig> $default$statusConfig() {
        return new ArrayList<StatusConfig>();
    }

    private static List<ConfigEntry> $default$configs() {
        return new ArrayList<ConfigEntry>();
    }

    public static ProcessConfigBuilder builder() {
        return new ProcessConfigBuilder();
    }

    public String getKey() {
        return this.key;
    }

    public String getStatusDokument() {
        return this.statusDokument;
    }

    public List<StatusConfig> getStatusConfig() {
        return this.statusConfig;
    }

    public List<ConfigEntry> getConfigs() {
        return this.configs;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setStatusDokument(String statusDokument) {
        this.statusDokument = statusDokument;
    }

    public void setStatusConfig(List<StatusConfig> statusConfig) {
        this.statusConfig = statusConfig;
    }

    public void setConfigs(List<ConfigEntry> configs) {
        this.configs = configs;
    }

    public String toString() {
        return "ProcessConfig(key=" + this.getKey() + ", statusDokument=" + this.getStatusDokument() + ", statusConfig=" + this.getStatusConfig() + ", configs=" + this.getConfigs() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessConfig)) {
            return false;
        }
        ProcessConfig other = (ProcessConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$statusDokument = this.getStatusDokument();
        String other$statusDokument = other.getStatusDokument();
        if (this$statusDokument == null ? other$statusDokument != null : !this$statusDokument.equals(other$statusDokument)) {
            return false;
        }
        List this$statusConfig = this.getStatusConfig();
        List other$statusConfig = other.getStatusConfig();
        if (this$statusConfig == null ? other$statusConfig != null : !((Object)this$statusConfig).equals(other$statusConfig)) {
            return false;
        }
        List this$configs = this.getConfigs();
        List other$configs = other.getConfigs();
        return !(this$configs == null ? other$configs != null : !((Object)this$configs).equals(other$configs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProcessConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $statusDokument = this.getStatusDokument();
        result = result * 59 + ($statusDokument == null ? 43 : $statusDokument.hashCode());
        List $statusConfig = this.getStatusConfig();
        result = result * 59 + ($statusConfig == null ? 43 : ((Object)$statusConfig).hashCode());
        List $configs = this.getConfigs();
        result = result * 59 + ($configs == null ? 43 : ((Object)$configs).hashCode());
        return result;
    }

    public ProcessConfig(String key, String statusDokument, List<StatusConfig> statusConfig, List<ConfigEntry> configs) {
        this.key = key;
        this.statusDokument = statusDokument;
        this.statusConfig = statusConfig;
        this.configs = configs;
    }
}

