/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.process.config.domain.service;

import io.muenchendigital.digiwf.process.config.domain.mapper.ProcessConfigMapper;
import io.muenchendigital.digiwf.process.config.domain.model.ProcessConfig;
import io.muenchendigital.digiwf.process.config.infrastructure.entity.ProcessConfigEntity;
import io.muenchendigital.digiwf.process.config.infrastructure.repository.ProcessConfigRepository;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ProcessConfigService {
    private static final Logger log = LoggerFactory.getLogger(ProcessConfigService.class);
    private final ProcessConfigMapper processConfigConvert;
    private final ProcessConfigRepository processConfigJpaRepository;

    public Optional<ProcessConfig> getProcessConfig(String key) {
        return this.processConfigJpaRepository.findByKey(key).map(arg_0 -> ((ProcessConfigMapper)this.processConfigConvert).map(arg_0));
    }

    public ProcessConfig saveProcessConfig(ProcessConfig processConfig) {
        Optional entity = this.processConfigJpaRepository.findByKey(processConfig.getKey());
        ProcessConfigEntity newEntity = this.processConfigConvert.map2Entity(processConfig);
        entity.ifPresent(formEntity -> newEntity.setId(formEntity.getId()));
        ProcessConfigEntity savedEntity = (ProcessConfigEntity)this.processConfigJpaRepository.save((Object)newEntity);
        log.info("process config deployed: {}", (Object)savedEntity);
        return this.processConfigConvert.map(savedEntity);
    }

    public ProcessConfigService(ProcessConfigMapper processConfigConvert, ProcessConfigRepository processConfigJpaRepository) {
        this.processConfigConvert = processConfigConvert;
        this.processConfigJpaRepository = processConfigJpaRepository;
    }
}

