/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.process.config.process;

import io.muenchendigital.digiwf.process.config.domain.model.ProcessConfig;
import io.muenchendigital.digiwf.process.config.domain.service.ProcessConfigService;
import java.util.Optional;
import org.camunda.bpm.engine.impl.context.BpmnExecutionContext;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.springframework.stereotype.Component;

@Component(value="processconfig")
public class ProcessConfigFunctions {
    private final ProcessConfigService processConfigService;

    public String get(String key) {
        Optional processConfig = this.getProcessConfigForCurrentProcess();
        return processConfig.map(config -> config.getConfig(key)).orElse(null);
    }

    public Optional<String> get(String configKey, String processKey) {
        Optional<String> configValue = Optional.ofNullable(this.get(configKey));
        if (configValue.isEmpty()) {
            configValue = this.processConfigService.getProcessConfig(processKey).map(processConfig -> processConfig.getConfig(configKey));
        }
        return configValue;
    }

    public String getStatusDokument() {
        ProcessConfig processConfig = (ProcessConfig)this.getProcessConfigForCurrentProcess().orElseThrow();
        return processConfig.getStatusDokument();
    }

    private Optional<ProcessConfig> getProcessConfigForCurrentProcess() {
        BpmnExecutionContext context = Context.getBpmnExecutionContext();
        if (context == null) {
            return Optional.empty();
        }
        String currentProcess = ((ExecutionEntity)context.getExecution()).getProcessDefinition().getKey();
        return this.processConfigService.getProcessConfig(currentProcess);
    }

    public ProcessConfigFunctions(ProcessConfigService processConfigService) {
        this.processConfigService = processConfigService;
    }
}

