/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.process.definition.api.resource;

import io.muenchendigital.digiwf.process.definition.api.mapper.ServiceDefinitionApiMapper;
import io.muenchendigital.digiwf.process.definition.api.transport.ServiceDefinitionDetailTO;
import io.muenchendigital.digiwf.process.definition.api.transport.ServiceDefinitionTO;
import io.muenchendigital.digiwf.process.definition.api.transport.StartInstanceTO;
import io.muenchendigital.digiwf.process.definition.domain.facade.ServiceDefinitionFacade;
import io.muenchendigital.digiwf.process.definition.domain.model.ServiceDefinitionDetail;
import io.muenchendigital.digiwf.shared.security.AppAuthenticationProvider;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
@RequestMapping(value={"/rest/service/definition"})
@Tag(name="ServiceDefinitionController", description="API to interact with service definitions")
public class ServiceDefinitionController {
    private final ServiceDefinitionFacade serviceDefinitionFacade;
    private final AppAuthenticationProvider authenticationProvider;
    private final ServiceDefinitionApiMapper serviceDefinitionApiMapper;

    @GetMapping
    @Operation(description="load all available service definitions")
    public ResponseEntity<List<ServiceDefinitionTO>> getServiceDefinitions() {
        List definitions = this.serviceDefinitionFacade.getStartableServiceDefinitions(this.authenticationProvider.getCurrentUserId(), this.authenticationProvider.getCurrentUserGroups());
        return ResponseEntity.ok((Object)this.serviceDefinitionApiMapper.map2TO(definitions));
    }

    @GetMapping(value={"/{key}"})
    @Operation(description="Get a specific service definition")
    public ResponseEntity<ServiceDefinitionDetailTO> getServiceDefinition(@PathVariable(value="key") String key) {
        ServiceDefinitionDetail definition = this.serviceDefinitionFacade.getServiceDefinitionDetail(key, this.authenticationProvider.getCurrentUserId(), this.authenticationProvider.getCurrentUserGroups());
        return ResponseEntity.ok((Object)this.serviceDefinitionApiMapper.map2TO(definition));
    }

    @PostMapping
    @Operation(description="Start a specific service")
    public ResponseEntity<Void> startInstance(@RequestBody StartInstanceTO to) {
        this.serviceDefinitionFacade.startInstance(to.getKey(), to.getVariables(), this.authenticationProvider.getCurrentUserId(), this.authenticationProvider.getCurrentUserGroups());
        return ResponseEntity.ok().build();
    }

    public ServiceDefinitionController(ServiceDefinitionFacade serviceDefinitionFacade, AppAuthenticationProvider authenticationProvider, ServiceDefinitionApiMapper serviceDefinitionApiMapper) {
        this.serviceDefinitionFacade = serviceDefinitionFacade;
        this.authenticationProvider = authenticationProvider;
        this.serviceDefinitionApiMapper = serviceDefinitionApiMapper;
    }
}

