/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.process.definition.api.streaming;

import io.muenchendigital.digiwf.asyncapi.docs.annotations.DocumentAsyncAPI;
import io.muenchendigital.digiwf.legacy.user.domain.service.UserService;
import io.muenchendigital.digiwf.process.definition.api.streaming.StartInstanceTOV01;
import io.muenchendigital.digiwf.process.definition.domain.facade.ServiceDefinitionFacade;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Component;

@Component
public class ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(ProcessEventListener.class);
    public static final String DEFAULT_USER = "digiwf";
    private final ServiceDefinitionFacade serviceDefinitionFacade;
    private final UserService userService;

    @DocumentAsyncAPI(payload=StartInstanceTOV01.class, functionRouter=true, typeHeader="startProcessV01")
    @Bean
    public Consumer<Message<StartInstanceTOV01>> startProcessV01() {
        return startInstance -> {
            log.info("Received process start {}", startInstance.getPayload());
            this.serviceDefinitionFacade.startInstance(((StartInstanceTOV01)startInstance.getPayload()).getKey(), ((StartInstanceTOV01)startInstance.getPayload()).getBusinessKey(), ((StartInstanceTOV01)startInstance.getPayload()).getFileContext(), ((StartInstanceTOV01)startInstance.getPayload()).getData(), StringUtils.isBlank((CharSequence)((StartInstanceTOV01)startInstance.getPayload()).getStarterOfInstance()) ? DEFAULT_USER : ((StartInstanceTOV01)startInstance.getPayload()).getStarterOfInstance(), this.getUserGroups(((StartInstanceTOV01)startInstance.getPayload()).getStarterOfInstance()));
        };
    }

    private List<String> getUserGroups(String starterOfInstance) {
        List groups = List.of();
        if (StringUtils.isNotBlank((CharSequence)starterOfInstance) && this.userService.getUserOrNull(starterOfInstance).isPresent()) {
            groups = this.userService.getGroups(starterOfInstance);
        }
        return groups;
    }

    public ProcessEventListener(ServiceDefinitionFacade serviceDefinitionFacade, UserService userService) {
        this.serviceDefinitionFacade = serviceDefinitionFacade;
        this.userService = userService;
    }
}

