/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.process.definition.domain.facade;

import io.muenchendigital.digiwf.jsonschema.domain.model.JsonSchema;
import io.muenchendigital.digiwf.jsonschema.domain.service.JsonSchemaService;
import io.muenchendigital.digiwf.process.config.process.ProcessConfigFunctions;
import io.muenchendigital.digiwf.process.definition.domain.model.ServiceDefinition;
import io.muenchendigital.digiwf.process.definition.domain.model.ServiceDefinitionDetail;
import io.muenchendigital.digiwf.process.definition.domain.model.StartContext;
import io.muenchendigital.digiwf.process.definition.domain.service.ServiceDefinitionAuthService;
import io.muenchendigital.digiwf.process.definition.domain.service.ServiceDefinitionDataService;
import io.muenchendigital.digiwf.process.definition.domain.service.ServiceDefinitionService;
import io.muenchendigital.digiwf.process.definition.domain.service.ServiceStartContextService;
import io.muenchendigital.digiwf.process.instance.process.properties.S3Properties;
import io.muenchendigital.digiwf.shared.exception.IllegalResourceAccessException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.FormService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ServiceDefinitionFacade {
    private static final Logger log = LoggerFactory.getLogger(ServiceDefinitionFacade.class);
    private final ServiceDefinitionService serviceDefinitionService;
    private final ServiceDefinitionAuthService serviceDefinitionAuthService;
    private final ServiceDefinitionDataService serviceDefinitionDataService;
    private final ServiceStartContextService serviceStartContextService;
    private final JsonSchemaService jsonSchemaService;
    private final io.muenchendigital.digiwf.legacy.form.domain.service.FormService formService;
    private final FormService camundaFormService;
    private final ProcessConfigFunctions processConfigFunctions;
    private final S3Properties s3Properties;

    public void startInstance(String key, Map<String, Object> variables, String userId, List<String> groups) {
        this.startInstance(key, null, null, variables, userId, groups);
    }

    public void startInstance(String key, String businessKey, Map<String, Object> variables, String userId, List<String> groups) {
        this.startInstance(key, businessKey, null, variables, userId, groups);
    }

    public void startInstance(String key, String businessKey, String fileContext, Map<String, Object> variables, String userId, List<String> groups) {
        StartContext startContext = this.serviceStartContextService.getStartContext(userId, key).orElse(new StartContext(userId, key, fileContext));
        ServiceDefinitionDetail definition = this.getServiceDefinitionDetailAuthorized(key, userId, groups);
        Map serializedVariables = this.serviceDefinitionDataService.serializeVariables(definition, variables);
        this.processConfigFunctions.get("app_file_s3_async_config", definition.getKey()).ifPresentOrElse(configValue -> serializedVariables.put("app_file_s3_async_config", configValue), () -> serializedVariables.put("app_file_s3_async_config", this.s3Properties.getTopic()));
        this.processConfigFunctions.get("app_file_s3_sync_config", definition.getKey()).ifPresentOrElse(configValue -> serializedVariables.put("app_file_s3_sync_config", configValue), () -> serializedVariables.put("app_file_s3_sync_config", this.s3Properties.getHttpAPI()));
        this.serviceDefinitionService.startInstance(definition, businessKey, serializedVariables, userId, startContext);
        this.serviceStartContextService.deleteStartContext(userId, key);
    }

    public ServiceDefinitionDetail getServiceDefinitionDetail(String key, String userId, List<String> groups) {
        if (!this.serviceDefinitionAuthService.allowedToStartDefinition(userId, groups, key)) {
            throw new IllegalResourceAccessException(String.format("Service definition not accessible: %s", key));
        }
        if (this.serviceStartContextService.getStartContext(userId, key).isEmpty()) {
            this.serviceStartContextService.createStartContext(userId, key);
        }
        ServiceDefinitionDetail detail = this.serviceDefinitionService.getServiceDefinitionDetail(key, userId, groups);
        this.addFormData(detail);
        return detail;
    }

    public List<ServiceDefinition> getStartableServiceDefinitions(String userId, List<String> groups) {
        List serviceDefinitions = this.serviceDefinitionService.getServiceDefinitions();
        return serviceDefinitions.stream().filter(definition -> this.serviceDefinitionAuthService.allowedToStartDefinition(userId, groups, definition.getKey())).collect(Collectors.toList());
    }

    private void addFormData(ServiceDefinitionDetail detail) {
        String formKey = this.camundaFormService.getStartFormKey(detail.getId());
        Optional form = this.formService.getStartForm(formKey);
        form.ifPresent(arg_0 -> ((ServiceDefinitionDetail)detail).setForm(arg_0));
        if (form.isEmpty()) {
            Optional schema = this.jsonSchemaService.getByKey(formKey);
            schema.map(JsonSchema::getSchemaMap).ifPresent(arg_0 -> ((ServiceDefinitionDetail)detail).setJsonSchema(arg_0));
        }
    }

    private ServiceDefinitionDetail getServiceDefinitionDetailAuthorized(String key, String userId, List<String> groups) {
        if (!this.serviceDefinitionAuthService.allowedToStartDefinition(userId, groups, key)) {
            throw new IllegalResourceAccessException(String.format("Service definition not accessible: %s", key));
        }
        ServiceDefinitionDetail detail = this.serviceDefinitionService.getServiceDefinitionDetail(key, userId, groups);
        this.addFormData(detail);
        return detail;
    }

    public ServiceDefinitionFacade(ServiceDefinitionService serviceDefinitionService, ServiceDefinitionAuthService serviceDefinitionAuthService, ServiceDefinitionDataService serviceDefinitionDataService, ServiceStartContextService serviceStartContextService, JsonSchemaService jsonSchemaService, io.muenchendigital.digiwf.legacy.form.domain.service.FormService formService, FormService camundaFormService, ProcessConfigFunctions processConfigFunctions, S3Properties s3Properties) {
        this.serviceDefinitionService = serviceDefinitionService;
        this.serviceDefinitionAuthService = serviceDefinitionAuthService;
        this.serviceDefinitionDataService = serviceDefinitionDataService;
        this.serviceStartContextService = serviceStartContextService;
        this.jsonSchemaService = jsonSchemaService;
        this.formService = formService;
        this.camundaFormService = camundaFormService;
        this.processConfigFunctions = processConfigFunctions;
        this.s3Properties = s3Properties;
    }
}

