/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.process.instance.domain.service;

import io.muenchendigital.digiwf.process.instance.infrastructure.entity.ServiceInstanceAuthorizationEntity;
import io.muenchendigital.digiwf.process.instance.infrastructure.repository.ProcessInstanceAuthorizationRepository;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="processInstanceAuthService")
public class ServiceInstanceAuthService {
    private static final Logger log = LoggerFactory.getLogger(ServiceInstanceAuthService.class);
    private final ProcessInstanceAuthorizationRepository processInstanceAuthorizationRepository;

    public List<String> getAllServiceInstanceIdsByUser(String userId) {
        return this.processInstanceAuthorizationRepository.findAllByUserId(userId).stream().map(ServiceInstanceAuthorizationEntity::getProcessInstanceId).collect(Collectors.toList());
    }

    public void createAuthorization(String processInstanceId, String userId) {
        if (this.hasAccess(processInstanceId, userId)) {
            return;
        }
        ServiceInstanceAuthorizationEntity entity = ServiceInstanceAuthorizationEntity.builder().processInstanceId(processInstanceId).userId(userId).build();
        this.processInstanceAuthorizationRepository.save((Object)entity);
    }

    public boolean hasAccess(String instanceId, String userId) {
        return this.processInstanceAuthorizationRepository.findByUserIdAndProcessInstanceId(userId, instanceId).isPresent();
    }

    public ServiceInstanceAuthService(ProcessInstanceAuthorizationRepository processInstanceAuthorizationRepository) {
        this.processInstanceAuthorizationRepository = processInstanceAuthorizationRepository;
    }
}

