/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.process.instance.domain.service;

import io.muenchendigital.digiwf.engine.mapper.EngineDataMapper;
import io.muenchendigital.digiwf.json.serialization.JsonSerializationService;
import io.muenchendigital.digiwf.jsonschema.domain.model.JsonSchema;
import java.util.Map;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ServiceInstanceDataService {
    private static final Logger log = LoggerFactory.getLogger(ServiceInstanceDataService.class);
    private final JsonSerializationService serializationService;
    private final HistoryService historyService;
    private final EngineDataMapper engineDataMapper;

    public Map<String, Object> getVariables(String instanceId, JsonSchema schema) {
        Map<String, Object> typedVariables = this.historyService.createHistoricVariableInstanceQuery().executionIdIn(new String[]{instanceId}).processInstanceId(instanceId).list().stream().filter(obj -> obj.getValue() != null).collect(Collectors.toMap(HistoricVariableInstance::getName, HistoricVariableInstance::getValue));
        return this.engineDataMapper.mapToData(this.serializationService.deserializeData(schema.getSchemaMap(), typedVariables));
    }

    public String getFileContext(String instanceId) {
        return (String)((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().executionIdIn(new String[]{instanceId}).processInstanceId(instanceId).variableName("app_file_context").singleResult()).getValue();
    }

    public ServiceInstanceDataService(JsonSerializationService serializationService, HistoryService historyService, EngineDataMapper engineDataMapper) {
        this.serializationService = serializationService;
        this.historyService = historyService;
        this.engineDataMapper = engineDataMapper;
    }
}

