/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.process.instance.domain.service;

import io.muenchendigital.digiwf.process.config.domain.model.ProcessConfig;
import io.muenchendigital.digiwf.process.config.domain.service.ProcessConfigService;
import io.muenchendigital.digiwf.process.config.process.ProcessConfigFunctions;
import io.muenchendigital.digiwf.process.instance.domain.model.ServiceInstance;
import io.muenchendigital.digiwf.process.instance.domain.service.ServiceInstanceAuthService;
import io.muenchendigital.digiwf.process.instance.domain.service.ServiceInstanceDataService;
import io.muenchendigital.digiwf.process.instance.domain.service.ServiceInstanceService;
import io.muenchendigital.digiwf.s3.integration.client.repository.DocumentStorageFolderRepository;
import io.muenchendigital.digiwf.shared.exception.IllegalResourceAccessException;
import io.muenchendigital.digiwf.shared.file.AbstractFileService;
import io.muenchendigital.digiwf.shared.file.presignedUrlAdapters.PresignedUrlAction;
import io.muenchendigital.digiwf.shared.file.presignedUrlAdapters.PresignedUrlAdapter;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;

@Service
public class ServiceInstanceFileService
extends AbstractFileService {
    private static final Logger log = LoggerFactory.getLogger(ServiceInstanceFileService.class);
    private final ProcessConfigService processConfigService;
    private final ServiceInstanceService serviceInstanceService;
    private final ServiceInstanceDataService serviceInstanceDataService;
    private final ServiceInstanceAuthService serviceInstanceAuthService;

    public ServiceInstanceFileService(DocumentStorageFolderRepository documentStorageFolderRepository, List<PresignedUrlAdapter> presignedUrlAdapters, ServiceInstanceService serviceInstanceService, ServiceInstanceDataService serviceInstanceDataService, ServiceInstanceAuthService serviceInstanceAuthService, ProcessConfigService processConfigService, ProcessConfigFunctions processConfigFunctions) {
        super(documentStorageFolderRepository, presignedUrlAdapters, processConfigFunctions);
        this.serviceInstanceService = serviceInstanceService;
        this.processConfigService = processConfigService;
        this.serviceInstanceDataService = serviceInstanceDataService;
        this.serviceInstanceAuthService = serviceInstanceAuthService;
    }

    public List<String> getFileNames(String infoId, String filePath, String userId) {
        ServiceInstance processInstance = this.getProcessInstanceId(infoId);
        String processInstanceId = processInstance.getInstanceId();
        if (!this.serviceInstanceAuthService.hasAccess(processInstanceId, userId)) {
            throw new AccessDeniedException("403 returned");
        }
        this.checkReadAccess(processInstanceId, filePath);
        String fileContext = this.getFileContext(processInstanceId);
        return super.getFileNames(filePath, fileContext, this.getDocumentStorageUrl(processInstance.getDefinitionKey()));
    }

    public String getPresignedUrl(PresignedUrlAction action, String infoId, String filePath, String fileName, String userId) {
        ServiceInstance processInstance = this.getProcessInstanceId(infoId);
        String processInstanceId = processInstance.getInstanceId();
        if (!this.serviceInstanceAuthService.hasAccess(processInstanceId, userId)) {
            throw new AccessDeniedException("403 returned");
        }
        if (action.equals((Object)PresignedUrlAction.GET)) {
            this.checkReadAccess(processInstanceId, filePath);
        } else {
            this.checkWriteAccess(processInstanceId, filePath);
        }
        String fileContext = this.getFileContext(processInstanceId);
        return super.getPresignedUrl(action, fileContext + "/" + filePath + "/" + fileName, this.getDocumentStorageUrl(processInstance.getDefinitionKey()));
    }

    private String getFileContext(String instanceId) {
        return this.serviceInstanceDataService.getFileContext(instanceId);
    }

    private void checkReadAccess(String identifier, String filePath) {
        try {
            this.checkWriteAccess(identifier, filePath);
        }
        catch (IllegalResourceAccessException ex) {
            String defintionKey = this.getDefinitionKey(identifier);
            String filePathsReadonly = this.processConfigService.getProcessConfig(defintionKey).map(ProcessConfig::getInstanceFilePathsReadonly).orElse(null);
            this.checkAccess(filePath, filePathsReadonly);
        }
    }

    private void checkWriteAccess(String identifier, String filePath) {
        String defintionKey = this.getDefinitionKey(identifier);
        String filePaths = this.processConfigService.getProcessConfig(defintionKey).map(ProcessConfig::getInstanceFilePaths).orElse(null);
        this.checkAccess(filePath, filePaths);
    }

    private void checkAccess(String filePath, String filePaths) {
        if (StringUtils.isEmpty((CharSequence)filePaths)) {
            throw new IllegalResourceAccessException("No access to defined property");
        }
        Arrays.stream(filePaths.split(";")).filter(filePath::startsWith).findFirst().orElseThrow(() -> new IllegalResourceAccessException("No access to defined property"));
    }

    private String getDefinitionKey(String instanceId) {
        return this.serviceInstanceService.getServiceInstanceByInstanceId(instanceId).map(ServiceInstance::getDefinitionKey).orElseThrow();
    }

    private ServiceInstance getProcessInstanceId(String instanceId) {
        return (ServiceInstance)this.serviceInstanceService.getServiceInstanceById(instanceId).orElseThrow();
    }
}

