/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.process.instance.domain.service;

import io.muenchendigital.digiwf.jsonschema.domain.model.JsonSchema;
import io.muenchendigital.digiwf.jsonschema.domain.service.JsonSchemaService;
import io.muenchendigital.digiwf.process.config.domain.model.ProcessConfig;
import io.muenchendigital.digiwf.process.config.domain.service.ProcessConfigService;
import io.muenchendigital.digiwf.process.instance.domain.mapper.HistoryTaskMapper;
import io.muenchendigital.digiwf.process.instance.domain.mapper.ServiceInstanceMapper;
import io.muenchendigital.digiwf.process.instance.domain.model.ServiceInstance;
import io.muenchendigital.digiwf.process.instance.domain.model.ServiceInstanceDetail;
import io.muenchendigital.digiwf.process.instance.domain.service.ServiceInstanceAuthService;
import io.muenchendigital.digiwf.process.instance.domain.service.ServiceInstanceDataService;
import io.muenchendigital.digiwf.process.instance.infrastructure.entity.ServiceInstanceEntity;
import io.muenchendigital.digiwf.process.instance.infrastructure.repository.ProcessInstanceInfoRepository;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.HistoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ServiceInstanceService {
    private static final Logger log = LoggerFactory.getLogger(ServiceInstanceService.class);
    private final HistoryService historyService;
    private final ProcessConfigService processConfigService;
    private final ServiceInstanceAuthService serviceInstanceAuthService;
    private final ProcessInstanceInfoRepository processInstanceInfoRepository;
    private final ServiceInstanceMapper serviceInstanceMapper;
    private final HistoryTaskMapper historyTaskMapper;
    private final JsonSchemaService jsonSchemaService;
    private final ServiceInstanceDataService serviceInstanceDataService;

    public List<ServiceInstance> getProcessInstanceByUser(String userId) {
        List processAuthIds = this.serviceInstanceAuthService.getAllServiceInstanceIdsByUser(userId);
        return this.serviceInstanceMapper.map2Model(this.processInstanceInfoRepository.findAllByInstanceIdIn(processAuthIds));
    }

    public ServiceInstanceDetail getServiceInstanceDetail(String infoId) {
        ServiceInstance processInstanceInfo = (ServiceInstance)this.getServiceInstanceById(infoId).orElseThrow();
        ProcessConfig processConfig = (ProcessConfig)this.processConfigService.getProcessConfig(processInstanceInfo.getDefinitionKey()).orElseThrow();
        List tasks = this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceInfo.getInstanceId()).list();
        ServiceInstanceDetail detail = this.serviceInstanceMapper.map2Detail(processInstanceInfo);
        detail.setConfig(processConfig);
        detail.setHistoryTasks(this.historyTaskMapper.map2Model(tasks));
        if (StringUtils.isNotBlank((CharSequence)processConfig.getInstanceSchemaKey())) {
            JsonSchema jsonSchema = (JsonSchema)this.jsonSchemaService.getByKey(processConfig.getInstanceSchemaKey()).orElseThrow();
            Map data = this.serviceInstanceDataService.getVariables(processInstanceInfo.getInstanceId(), jsonSchema);
            detail.setData(data);
            detail.setJsonSchema(jsonSchema.getSchemaMap());
        }
        return detail;
    }

    public Optional<ServiceInstance> getServiceInstanceById(String id) {
        return this.processInstanceInfoRepository.findById((Object)id).map(arg_0 -> ((ServiceInstanceMapper)this.serviceInstanceMapper).map2Model(arg_0));
    }

    public Optional<ServiceInstance> getServiceInstanceByInstanceId(String instanceId) {
        return this.processInstanceInfoRepository.findByInstanceId(instanceId).map(arg_0 -> ((ServiceInstanceMapper)this.serviceInstanceMapper).map2Model(arg_0));
    }

    public ServiceInstance creatServiceInstance(String definitionName, String definitionKey) {
        ServiceInstance serviceInstance = ServiceInstance.builder().definitionName(definitionName).startTime(new Date()).definitionKey(definitionKey).status("Gestartet").build();
        return this.saveServiceInstance(serviceInstance);
    }

    public ServiceInstance saveServiceInstance(ServiceInstance serviceInstance) {
        ServiceInstanceEntity persistedProcessInstanceInfo = (ServiceInstanceEntity)this.processInstanceInfoRepository.save((Object)this.serviceInstanceMapper.map2Entity(serviceInstance));
        return this.serviceInstanceMapper.map2Model(persistedProcessInstanceInfo);
    }

    public void authorizeServiceInstance(String instanceId, String userId) {
        this.serviceInstanceAuthService.createAuthorization(instanceId, userId);
    }

    public void updateInstanceId(String serviceInstanceId, String instanceId) {
        ServiceInstance serviceInstance = (ServiceInstance)this.getServiceInstanceById(serviceInstanceId).orElseThrow();
        serviceInstance.updateProcessInstanceId(instanceId);
        this.saveServiceInstance(serviceInstance);
    }

    public List<ServiceInstance> getProcessInstanceByRemovalTimeBefore(Date referenceDate) {
        List instances = this.processInstanceInfoRepository.findByRemovalTimeBefore(referenceDate);
        return this.serviceInstanceMapper.map2Model(instances);
    }

    public void cleanupInstance(String instanceId) {
        Optional entity = this.processInstanceInfoRepository.findByInstanceId(instanceId);
        if (entity.isPresent()) {
            this.processInstanceInfoRepository.delete((Object)((ServiceInstanceEntity)entity.get()));
            log.info("Service instance cleaned up: {}", (Object)((ServiceInstanceEntity)entity.get()).getInstanceId());
        }
    }

    public ServiceInstanceService(HistoryService historyService, ProcessConfigService processConfigService, ServiceInstanceAuthService serviceInstanceAuthService, ProcessInstanceInfoRepository processInstanceInfoRepository, ServiceInstanceMapper serviceInstanceMapper, HistoryTaskMapper historyTaskMapper, JsonSchemaService jsonSchemaService, ServiceInstanceDataService serviceInstanceDataService) {
        this.historyService = historyService;
        this.processConfigService = processConfigService;
        this.serviceInstanceAuthService = serviceInstanceAuthService;
        this.processInstanceInfoRepository = processInstanceInfoRepository;
        this.serviceInstanceMapper = serviceInstanceMapper;
        this.historyTaskMapper = historyTaskMapper;
        this.jsonSchemaService = jsonSchemaService;
        this.serviceInstanceDataService = serviceInstanceDataService;
    }
}

