/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.process.instance.process;

import io.muenchendigital.digiwf.process.config.domain.model.ProcessConfig;
import io.muenchendigital.digiwf.process.config.domain.service.ProcessConfigService;
import io.muenchendigital.digiwf.process.instance.domain.model.ServiceInstance;
import io.muenchendigital.digiwf.process.instance.domain.service.ServiceInstanceService;
import java.util.Optional;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.springframework.stereotype.Component;

@Component(value="process")
public class ProcessFunctions {
    private final ProcessConfigService processConfigService;
    private final ServiceInstanceService processInstanceService;

    public void setStatus(String statusKey) {
        ProcessConfig processConfig = (ProcessConfig)this.processConfigService.getProcessConfig(this.getCurrentProcessKey()).orElseThrow();
        ((ExecutionEntity)Context.getBpmnExecutionContext().getExecution()).setVariable("app_process_status", (Object)statusKey);
        String instanceId = ((ExecutionEntity)Context.getBpmnExecutionContext().getExecution()).getProcessInstanceId();
        ServiceInstance processInstanceInfo = (ServiceInstance)Optional.ofNullable(((ExecutionEntity)Context.getBpmnExecutionContext().getExecution()).getVariable("app_process_info_id")).map(Object::toString).map(arg_0 -> ((ServiceInstanceService)this.processInstanceService).getServiceInstanceById(arg_0)).orElseGet(() -> this.processInstanceService.getServiceInstanceByInstanceId(instanceId)).orElseThrow();
        processInstanceInfo.updateStatus(statusKey, processConfig.getStatus(statusKey));
        this.processInstanceService.saveServiceInstance(processInstanceInfo);
    }

    public void setDescription(String description) {
        String instanceId = ((ExecutionEntity)Context.getBpmnExecutionContext().getExecution()).getProcessInstanceId();
        ServiceInstance processInstanceInfo = (ServiceInstance)Optional.ofNullable(((ExecutionEntity)Context.getBpmnExecutionContext().getExecution()).getVariable("app_process_info_id")).map(Object::toString).map(arg_0 -> ((ServiceInstanceService)this.processInstanceService).getServiceInstanceById(arg_0)).orElseGet(() -> this.processInstanceService.getServiceInstanceByInstanceId(instanceId)).orElseThrow();
        processInstanceInfo.updateDescription(description);
        this.processInstanceService.saveServiceInstance(processInstanceInfo);
    }

    private String getCurrentProcessKey() {
        return ((ExecutionEntity)Context.getBpmnExecutionContext().getExecution()).getProcessDefinition().getKey();
    }

    public ProcessFunctions(ProcessConfigService processConfigService, ServiceInstanceService processInstanceService) {
        this.processConfigService = processConfigService;
        this.processInstanceService = processInstanceService;
    }
}

