/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.process.instance.process.listener;

import io.muenchendigital.digiwf.cleanup.services.calculation.CleanupCalculator;
import io.muenchendigital.digiwf.process.instance.domain.model.ServiceInstance;
import io.muenchendigital.digiwf.process.instance.domain.service.ServiceInstanceService;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.spring.boot.starter.event.ExecutionEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class ProcessCompleteListener {
    private final ServiceInstanceService processInstanceService;
    private final CleanupCalculator cleanupCalculator;

    @EventListener
    public void executionEvent(ExecutionEvent executionEvent) {
        if (!executionEvent.getEventName().equals("end")) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)executionEvent.getActivityInstanceId()) || !executionEvent.getActivityInstanceId().equals(executionEvent.getProcessInstanceId())) {
            return;
        }
        Optional processInstanceInfo = this.processInstanceService.getServiceInstanceByInstanceId(executionEvent.getProcessInstanceId());
        if (processInstanceInfo.isEmpty()) {
            return;
        }
        ServiceInstance instanceItem = (ServiceInstance)processInstanceInfo.get();
        Date endTime = new Date();
        Date removalTime = this.cleanupCalculator.calculateRemovalTime(instanceItem.getDefinitionKey(), instanceItem.getStartTime(), endTime);
        instanceItem.finished(endTime, removalTime);
        this.processInstanceService.saveServiceInstance(instanceItem);
    }

    public ProcessCompleteListener(ServiceInstanceService processInstanceService, CleanupCalculator cleanupCalculator) {
        this.processInstanceService = processInstanceService;
        this.cleanupCalculator = cleanupCalculator;
    }
}

