/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.shared.configuration;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import java.util.concurrent.TimeUnit;
import org.springframework.cache.Cache;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableCaching
public class CachingConfiguration {
    private static final int LDAP_CACHE_ENTRY_SECONDS_TO_EXPIRE = 28800;

    @Bean
    public Ticker ticker() {
        return Ticker.systemTicker();
    }

    @Bean
    public Cache ldapUsersCache(Ticker ticker) {
        return new CaffeineCache("ldapusers", Caffeine.newBuilder().expireAfterWrite(28800L, TimeUnit.SECONDS).ticker(ticker).build());
    }

    @Bean
    public Cache ldapUsersByNameCache(Ticker ticker) {
        return new CaffeineCache("ldapuserbyname", Caffeine.newBuilder().expireAfterWrite(28800L, TimeUnit.SECONDS).ticker(ticker).build());
    }

    @Bean
    public Cache ldapOusCache(Ticker ticker) {
        return new CaffeineCache("ldapous", Caffeine.newBuilder().expireAfterWrite(28800L, TimeUnit.SECONDS).ticker(ticker).build());
    }

    @Bean
    public Cache ldapOuTreeCache(Ticker ticker) {
        return new CaffeineCache("ldapoutree", Caffeine.newBuilder().expireAfterWrite(28800L, TimeUnit.SECONDS).ticker(ticker).build());
    }
}

