/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.shared.configuration;

import io.muenchendigital.digiwf.legacy.user.domain.service.UserService;
import io.muenchendigital.digiwf.shared.configuration.CamundaAuthenticationFilterConfiguration;
import io.muenchendigital.digiwf.shared.security.UserAuthenticationProvider;
import javax.servlet.Filter;
import org.camunda.bpm.engine.IdentityService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"!no-security"})
public class CamundaAuthenticationFilterConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CamundaAuthenticationFilterConfiguration.class);
    private final IdentityService identityService;
    private final UserAuthenticationProvider userProvider;
    private final UserService userService;

    @Bean
    public FilterRegistrationBean<?> statelessUserAuthenticationFilter() {
        FilterRegistrationBean filterRegistration = new FilterRegistrationBean();
        filterRegistration.setFilter((Filter)new CamundaUserAuthenticationFilter(this));
        filterRegistration.setOrder(102);
        filterRegistration.addUrlPatterns(new String[]{"/rest/*", "/engine-rest/*"});
        return filterRegistration;
    }

    public CamundaAuthenticationFilterConfiguration(IdentityService identityService, UserAuthenticationProvider userProvider, UserService userService) {
        this.identityService = identityService;
        this.userProvider = userProvider;
        this.userService = userService;
    }
}

