/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.shared.configuration;

import com.nimbusds.jose.shaded.json.JSONObject;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.core.ClaimAccessor;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class GrantedAuthoritiesConverter
extends JwtAuthenticationConverter {
    public static final String SPRING_ROLE_PREFIX = "ROLE_";
    private static final String ROLE_DECLARATIONS = "roles";
    private static final String REALM_ROLES_CLAIM = "realm_access";
    private static final String CLIENTS_CLAIM = "resource_access";
    private static final String USER_ROLES_CLAIM = "user_roles";
    private static final String CLIENT_ROLE_SEPARATOR = ":";

    protected Collection<GrantedAuthority> extractAuthorities(Jwt jwt) {
        List clientAuthorities = GrantedAuthoritiesConverter.getClientAuthorities((ClaimAccessor)jwt);
        List userRoles = GrantedAuthoritiesConverter.getUserRolesClaimAuthorities((ClaimAccessor)jwt);
        Map realmAccess = jwt.getClaimAsMap("realm_access");
        Collection<Object> realmAuthorities = Collections.emptyList();
        if (realmAccess != null && realmAccess.containsKey("roles")) {
            realmAuthorities = (Collection)realmAccess.get("roles");
        }
        return Stream.concat(Stream.concat(realmAuthorities.stream(), clientAuthorities.stream()).map(s -> "ROLE_" + s), userRoles.stream()).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }

    public static List<String> getClientAuthorities(ClaimAccessor jwt) {
        ArrayList<String> clientAuthorities = new ArrayList<String>();
        Map clientClaims = jwt.getClaimAsMap("resource_access");
        if (clientClaims != null) {
            clientClaims.forEach((client, claims) -> clientAuthorities.addAll(GrantedAuthoritiesConverter.extractRoles((String)client, (JSONObject)((JSONObject)claims))));
        }
        return clientAuthorities;
    }

    public static List<String> getUserRolesClaimAuthorities(ClaimAccessor jwt) {
        return jwt.getClaimAsStringList("user_roles");
    }

    static List<String> extractRoles(String client, JSONObject clientObject) {
        Collection clientRoles = (Collection)clientObject.get((Object)"roles");
        if (clientRoles != null) {
            return clientRoles.stream().map(role -> client + ":" + role).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<String> extractRoles(Principal principal) {
        if (principal instanceof Authentication) {
            return ((Authentication)principal).getAuthorities().stream().map(GrantedAuthority::getAuthority).map(role -> StringUtils.removeStart((String)role, (String)"ROLE_")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

