/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.shared.configuration;

import io.muenchendigital.digiwf.shared.configuration.JwtUserInfoAuthenticationConverter;
import io.muenchendigital.digiwf.shared.configuration.UserInfoAuthoritiesService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@Profile(value={"!no-security"})
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true, jsr250Enabled=true)
public class SecurityConfiguration {
    private static final String[] PERMITTED_URLS = new String[]{"/error", "/actuator/info", "/actuator/health", "/actuator/metrics", "/swagger-ui/index.html", "/swagger-ui*/*swagger-initializer.js", "/swagger-ui*/**", "/v3/api-docs/*", "/v3/api-docs", "/camunda/**"};
    private final RestTemplateBuilder restTemplateBuilder;
    @Value(value="${spring.security.oauth2.client.provider.keycloak.user-info-uri}")
    private String userInfoUri;

    @Bean
    public SecurityFilterChain configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().ignoringAntMatchers(PERMITTED_URLS).disable()).authorizeRequests().antMatchers(HttpMethod.OPTIONS)).permitAll().antMatchers(PERMITTED_URLS)).permitAll().anyRequest()).authenticated().and()).oauth2ResourceServer().jwt().jwtAuthenticationConverter(this.customCachingUserServiceConverter()).and();
        return (SecurityFilterChain)http.build();
    }

    private Converter<Jwt, AbstractAuthenticationToken> customCachingUserServiceConverter() {
        return new JwtUserInfoAuthenticationConverter(new UserInfoAuthoritiesService(this.userInfoUri, this.restTemplateBuilder));
    }

    public SecurityConfiguration(RestTemplateBuilder restTemplateBuilder) {
        this.restTemplateBuilder = restTemplateBuilder;
    }
}

