/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.shared.configuration;

import io.muenchendigital.digiwf.shared.nfcconverter.NfcRequestFilter;
import javax.servlet.Filter;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class UnicodeConfiguration {
    private static final String NFC_FILTER_NAME = "nfcRequestFilter";
    private static final String NFC_WHITE_LIST = "text/plain; application/json; application/hal+json; text/html";
    private static final String[] NFC_URLS = (String[])ArrayUtils.toArray((Object[])new String[]{"/rest/*"});

    @Bean
    public FilterRegistrationBean<NfcRequestFilter> nfcRequestFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)this.nfcRequestFilter());
        registration.setName(NFC_FILTER_NAME);
        registration.setOrder(Integer.MAX_VALUE);
        registration.setAsyncSupported(false);
        registration.addUrlPatterns(NFC_URLS);
        registration.addInitParameter("contentTypes", NFC_WHITE_LIST);
        return registration;
    }

    @Bean(name={"nfcRequestFilter"})
    public NfcRequestFilter nfcRequestFilter() {
        return new NfcRequestFilter();
    }
}

