/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.shared.configuration;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cache.Cache;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserInfoAuthoritiesService {
    private static final Logger log = LoggerFactory.getLogger(UserInfoAuthoritiesService.class);
    private static final String NAME_AUTHENTICATION_CACHE = "authentication_cache";
    private static final int AUTHENTICATION_CACHE_ENTRY_SECONDS_TO_EXPIRE = 60;
    private static final String CLAIM_AUTHORITIES = "authorities";
    private final String userInfoUri;
    private final RestTemplate restTemplate;
    private final Cache cache;

    public UserInfoAuthoritiesService(String userInfoUri, RestTemplateBuilder restTemplateBuilder) {
        this.userInfoUri = userInfoUri;
        this.restTemplate = restTemplateBuilder.build();
        this.cache = new CaffeineCache("authentication_cache", Caffeine.newBuilder().expireAfterWrite(60L, TimeUnit.SECONDS).ticker(Ticker.systemTicker()).build());
    }

    public Collection<SimpleGrantedAuthority> loadAuthorities(Jwt jwt) {
        Cache.ValueWrapper valueWrapper = this.cache.get((Object)jwt.getSubject());
        if (valueWrapper != null) {
            Collection authorities = (Collection)valueWrapper.get();
            log.debug("Resolved authorities (from cache): {}", (Object)authorities);
            return authorities;
        }
        log.debug("Fetching user-info for token subject: {}", (Object)jwt.getSubject());
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + jwt.getTokenValue());
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        try {
            Map map = (Map)this.restTemplate.exchange(this.userInfoUri, HttpMethod.GET, entity, Map.class, new Object[0]).getBody();
            log.debug("Response from user-info Endpoint: {}", (Object)map);
            if (map != null && map.containsKey("authorities")) {
                authorities.addAll(UserInfoAuthoritiesService.asAuthorities(map.get("authorities")));
            }
            if (map != null && map.containsKey("user_roles")) {
                authorities.addAll(UserInfoAuthoritiesService.asAuthorities(map.get("user_roles")));
            }
            log.debug("Resolved Authorities (from /userinfo Endpoint): {}", authorities);
            this.cache.put((Object)jwt.getSubject(), authorities);
        }
        catch (Exception e) {
            log.error(String.format("Could not fetch user details from %s - user is granted NO authorities", this.userInfoUri), (Throwable)e);
        }
        return authorities;
    }

    private static List<SimpleGrantedAuthority> asAuthorities(Object object) {
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            object = collection.toArray(new Object[0]);
        }
        if (ObjectUtils.isArray((Object)object)) {
            authorities.addAll(Stream.of((Object[])object).map(Object::toString).map(SimpleGrantedAuthority::new).collect(Collectors.toList()));
        }
        return authorities;
    }
}

