/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.shared.exception;

import io.muenchendigital.digiwf.json.validation.DigiWFValidationException;
import io.muenchendigital.digiwf.shared.exception.ConflictingResourceException;
import io.muenchendigital.digiwf.shared.exception.IllegalResourceAccessException;
import io.muenchendigital.digiwf.shared.exception.NoFileContextException;
import io.muenchendigital.digiwf.shared.exception.ObjectNotFoundException;
import io.muenchendigital.digiwf.shared.exception.VariablesNotValidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;

@ControllerAdvice
public class RestExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(RestExceptionHandler.class);

    @ExceptionHandler(value={ObjectNotFoundException.class, IllegalArgumentException.class})
    public ResponseEntity<Object> handleNotFound(RuntimeException ex, WebRequest request) {
        String bodyOfResponse = "Object not found";
        log.error("Client Exception 404.", (Throwable)ex);
        return this.handleExceptionInternal((Exception)ex, (Object)"Object not found", new HttpHeaders(), HttpStatus.NOT_FOUND, request);
    }

    @ExceptionHandler(value={VariablesNotValidException.class, NoFileContextException.class, DigiWFValidationException.class})
    public ResponseEntity<Object> handleBadRequest(RuntimeException ex, WebRequest request) {
        String bodyOfResponse = "Bad request";
        log.error("Client Exception 400.", (Throwable)ex);
        return this.handleExceptionInternal((Exception)ex, (Object)"Bad request", new HttpHeaders(), HttpStatus.BAD_REQUEST, request);
    }

    @ExceptionHandler(value={IllegalResourceAccessException.class})
    public ResponseEntity<Object> handleForbidden(RuntimeException ex, WebRequest request) {
        String bodyOfResponse = "Forbidden";
        log.error("Client Exception 403.", (Throwable)ex);
        return this.handleExceptionInternal((Exception)ex, (Object)"Forbidden", new HttpHeaders(), HttpStatus.FORBIDDEN, request);
    }

    @ExceptionHandler(value={ConflictingResourceException.class})
    public ResponseEntity<Object> handleConflict(RuntimeException ex, WebRequest request) {
        String bodyOfResponse = "Conflict";
        log.error("Client Exception 409.", (Throwable)ex);
        return this.handleExceptionInternal((Exception)ex, (Object)"Conflict", new HttpHeaders(), HttpStatus.CONFLICT, request);
    }

    private ResponseEntity<Object> handleExceptionInternal(Exception ex, @Nullable Object body, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return new ResponseEntity(body, (MultiValueMap)headers, status);
    }
}

