/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.shared.file.presignedUrlAdapters;

import io.muenchendigital.digiwf.process.instance.process.properties.S3Properties;
import io.muenchendigital.digiwf.s3.integration.client.repository.presignedurl.PresignedUrlRepository;
import io.muenchendigital.digiwf.shared.file.presignedUrlAdapters.PresignedUrlAction;
import io.muenchendigital.digiwf.shared.file.presignedUrlAdapters.PresignedUrlAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpServerErrorException;

@Component
public class DeletePresignedUrlAdapter
implements PresignedUrlAdapter {
    private static final Logger log = LoggerFactory.getLogger(DeletePresignedUrlAdapter.class);
    private final PresignedUrlRepository presignedUrlRepository;
    private final S3Properties s3Properties;

    public String getPresignedUrl(String pathToFile, int expireInMinutes) throws HttpServerErrorException {
        return this.getPresignedUrl(this.s3Properties.getHttpAPI(), pathToFile, expireInMinutes);
    }

    public String getPresignedUrl(String documentStorageUrl, String pathToFile, int expireInMinutes) {
        try {
            return this.presignedUrlRepository.getPresignedUrlDeleteFile(pathToFile, expireInMinutes, documentStorageUrl);
        }
        catch (Exception ex) {
            log.error("Getting presigned url for deleting file {} failed: {}", (Object)pathToFile, (Object)ex);
            throw new HttpServerErrorException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Getting presigned url for deleting file %s failed", pathToFile));
        }
    }

    public boolean isResponsibleForAction(PresignedUrlAction action) {
        return action.equals((Object)PresignedUrlAction.DELETE);
    }

    public DeletePresignedUrlAdapter(PresignedUrlRepository presignedUrlRepository, S3Properties s3Properties) {
        this.presignedUrlRepository = presignedUrlRepository;
        this.s3Properties = s3Properties;
    }
}

