/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.shared.gracefulshutdown;

import io.muenchendigital.digiwf.shared.gracefulshutdown.GracefulShutdownHealthCheck;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.catalina.connector.Connector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.stereotype.Component;

@Component
public class GracefulShutdown
implements TomcatConnectorCustomizer,
ApplicationListener<ContextClosedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(GracefulShutdown.class);
    private static final long MILLIS_PER_SECOND = 1000L;
    private volatile Connector connector;
    @Value(value="${tomcat.gracefulshutdown.pre-wait-seconds:20}")
    private int preWaitSeconds;
    @Value(value="${tomcat.gracefulshutdown.shutdown-wait-seconds:20}")
    private int shutdownWaitSeconds;
    @Autowired
    private GracefulShutdownHealthCheck healthCheck;

    public void customize(Connector connector) {
        this.connector = connector;
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        LOG.info("context close event happened");
        this.healthCheck.setStatusDown();
        try {
            Thread.sleep((long)this.preWaitSeconds * 1000L);
            this.connector.pause();
            Executor executor = this.connector.getProtocolHandler().getExecutor();
            if (executor instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executor;
                threadPoolExecutor.shutdown();
                if (!threadPoolExecutor.awaitTermination(this.shutdownWaitSeconds, TimeUnit.SECONDS)) {
                    LOG.warn("Tomcat thread pool did not shut down gracefully within {} seconds. Proceeding with forceful shutdown", (Object)this.shutdownWaitSeconds);
                    threadPoolExecutor.shutdownNow();
                } else {
                    LOG.warn("The application gracefully shuts down now. All pending requests were served.");
                }
            }
        }
        catch (InterruptedException ex) {
            LOG.warn("InterruptedException during shutdown happened");
            Thread.currentThread().interrupt();
        }
    }

    public String toString() {
        return "GracefulShutdown(connector=" + this.connector + ", preWaitSeconds=" + this.getPreWaitSeconds() + ", shutdownWaitSeconds=" + this.getShutdownWaitSeconds() + ", healthCheck=" + this.healthCheck + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GracefulShutdown)) {
            return false;
        }
        GracefulShutdown other = (GracefulShutdown)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getPreWaitSeconds() != other.getPreWaitSeconds()) {
            return false;
        }
        if (this.getShutdownWaitSeconds() != other.getShutdownWaitSeconds()) {
            return false;
        }
        Connector this$connector = this.connector;
        Connector other$connector = other.connector;
        if (this$connector == null ? other$connector != null : !this$connector.equals(other$connector)) {
            return false;
        }
        GracefulShutdownHealthCheck this$healthCheck = this.healthCheck;
        GracefulShutdownHealthCheck other$healthCheck = other.healthCheck;
        return !(this$healthCheck == null ? other$healthCheck != null : !this$healthCheck.equals(other$healthCheck));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GracefulShutdown;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPreWaitSeconds();
        result = result * 59 + this.getShutdownWaitSeconds();
        Connector $connector = this.connector;
        result = result * 59 + ($connector == null ? 43 : $connector.hashCode());
        GracefulShutdownHealthCheck $healthCheck = this.healthCheck;
        result = result * 59 + ($healthCheck == null ? 43 : $healthCheck.hashCode());
        return result;
    }

    public int getPreWaitSeconds() {
        return this.preWaitSeconds;
    }

    public int getShutdownWaitSeconds() {
        return this.shutdownWaitSeconds;
    }
}

