/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.shared.nfcconverter;

import io.muenchendigital.digiwf.shared.nfcconverter.NfcHelper;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NfcReader
extends Reader {
    private static final Logger LOG = LoggerFactory.getLogger(NfcReader.class);
    private final Reader original;
    private CharArrayReader converted;

    public NfcReader(Reader original) {
        this.original = original;
        this.converted = null;
    }

    private void convert() {
        if (this.converted != null) {
            return;
        }
        LOG.debug("Converting Reader data to NFC.");
        try {
            String nfdContent = IOUtils.toString((Reader)this.original);
            String nfcConvertedContent = NfcHelper.nfcConverter((String)nfdContent);
            this.converted = new CharArrayReader(nfcConvertedContent.toCharArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int read() throws IOException {
        this.convert();
        return this.converted.read();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.convert();
        return this.converted.read(cbuf, off, len);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public long skip(long n) throws IOException {
        this.convert();
        return this.converted.skip(n);
    }

    @Override
    public boolean ready() throws IOException {
        this.convert();
        return this.converted.ready();
    }

    @Override
    public boolean markSupported() {
        this.convert();
        return this.converted.markSupported();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.convert();
        this.converted.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        this.convert();
        this.converted.reset();
    }
}

