/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.shared.nfcconverter;

import io.muenchendigital.digiwf.shared.nfcconverter.NfcHelper;
import io.muenchendigital.digiwf.shared.nfcconverter.NfcReader;
import io.muenchendigital.digiwf.shared.nfcconverter.NfcServletInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.Part;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NfcRequest
extends HttpServletRequestWrapper
implements HttpServletRequest {
    private static final Logger LOG = LoggerFactory.getLogger(NfcRequest.class);
    private Map<String, String[]> params = null;
    private Cookie[] cookies = null;
    private Map<String, List<String>> headers = null;
    private Set<String> contentTypes;

    public NfcRequest(HttpServletRequest request, Set<String> contentTypes) {
        super(request);
        this.contentTypes = contentTypes;
    }

    private void convert() {
        if (this.params != null) {
            return;
        }
        this.params = NfcHelper.nfcConverter((Map)this.getRequest().getParameterMap());
        this.cookies = NfcHelper.nfcConverter((Cookie[])this.getOriginalRequest().getCookies());
        this.headers = NfcHelper.nfcConverterForHeadersFromOriginalRequest((HttpServletRequest)this.getOriginalRequest());
    }

    public Cookie[] getCookies() {
        this.convert();
        return this.cookies;
    }

    public String getHeader(String name) {
        this.convert();
        List values = (List)this.headers.get(NfcHelper.nfcConverter((String)name));
        return values == null ? null : (String)values.get(0);
    }

    public Enumeration<String> getHeaders(String name) {
        this.convert();
        List values = (List)this.headers.get(NfcHelper.nfcConverter((String)name));
        return values == null ? Collections.emptyEnumeration() : IteratorUtils.asEnumeration(values.iterator());
    }

    public Enumeration<String> getHeaderNames() {
        this.convert();
        return IteratorUtils.asEnumeration(this.headers.keySet().iterator());
    }

    public String getPathInfo() {
        this.convert();
        return NfcHelper.nfcConverter((String)this.getOriginalRequest().getPathInfo());
    }

    public String getPathTranslated() {
        this.convert();
        return NfcHelper.nfcConverter((String)this.getOriginalRequest().getPathTranslated());
    }

    public String getContextPath() {
        this.convert();
        return NfcHelper.nfcConverter((String)this.getOriginalRequest().getContextPath());
    }

    public String getQueryString() {
        this.convert();
        return NfcHelper.nfcConverter((String)this.getOriginalRequest().getQueryString());
    }

    public String getRemoteUser() {
        this.convert();
        return NfcHelper.nfcConverter((String)this.getOriginalRequest().getRemoteUser());
    }

    public String getRequestedSessionId() {
        this.convert();
        return NfcHelper.nfcConverter((String)this.getOriginalRequest().getRequestedSessionId());
    }

    public String getRequestURI() {
        this.convert();
        return NfcHelper.nfcConverter((String)this.getOriginalRequest().getRequestURI());
    }

    public StringBuffer getRequestURL() {
        this.convert();
        return NfcHelper.nfcConverter((StringBuffer)this.getOriginalRequest().getRequestURL());
    }

    public void login(String username, String password) throws ServletException {
        this.getOriginalRequest().login(NfcHelper.nfcConverter((String)username), password);
    }

    public String getParameter(String name) {
        this.convert();
        String[] values = (String[])this.params.get(NfcHelper.nfcConverter((String)name));
        return values == null ? null : values[0];
    }

    public Map<String, String[]> getParameterMap() {
        this.convert();
        return this.params;
    }

    public Enumeration<String> getParameterNames() {
        this.convert();
        return IteratorUtils.asEnumeration(this.params.keySet().iterator());
    }

    public String[] getParameterValues(String name) {
        this.convert();
        return (String[])this.params.get(NfcHelper.nfcConverter((String)name));
    }

    public BufferedReader getReader() throws IOException {
        LOG.debug("getReader()");
        return new BufferedReader((Reader)new NfcReader((Reader)this.getOriginalRequest().getReader()));
    }

    public String getRemoteHost() {
        return NfcHelper.nfcConverter((String)this.getRequest().getRemoteHost());
    }

    public Part getPart(String name) throws IOException, ServletException {
        LOG.debug("getPart({})", (Object)name);
        return this.getOriginalRequest().getPart(name);
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        LOG.debug("getParts()");
        return this.getOriginalRequest().getParts();
    }

    public ServletInputStream getInputStream() throws IOException {
        String encoding = this.getOriginalRequest().getCharacterEncoding();
        String content = null;
        try (ServletInputStream is = this.getOriginalRequest().getInputStream();){
            content = new String(IOUtils.toByteArray((InputStream)is), encoding);
        }
        LOG.debug("Converting InputStream data to NFC.");
        String nfcConvertedContent = NfcHelper.nfcConverter((String)content);
        return new NfcServletInputStream(new ByteArrayInputStream(nfcConvertedContent.getBytes()));
    }

    private HttpServletRequest getOriginalRequest() {
        return (HttpServletRequest)this.getRequest();
    }
}

