/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.shared.nfcconverter;

import io.muenchendigital.digiwf.shared.nfcconverter.NfcRequest;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class NfcRequestFilter
extends OncePerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(NfcRequestFilter.class);
    public static final String CONTENTTYPES_PROPERTY = "contentTypes";
    private Set<String> contentTypes = new HashSet();

    public String getContentTypes() {
        return String.join((CharSequence)"; ", this.contentTypes);
    }

    @Autowired(required=false)
    public void setContentTypes(String contentTypes) {
        this.contentTypes.clear();
        if (StringUtils.isEmpty((Object)contentTypes)) {
            LOG.info("Disabling context-type filter.");
        } else {
            Set newContentTypes = Arrays.asList(contentTypes.split(";")).stream().map(String::trim).collect(Collectors.toSet());
            this.contentTypes.addAll(newContentTypes);
            LOG.info("Enabled content-type filtering to NFC for: {}", (Object)this.getContentTypes());
        }
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        LOG.debug("Request-Type={}", (Object)request.getClass().getName());
        LOG.debug("Intercepting request for URI {}", (Object)request.getRequestURI());
        String contentType = request.getContentType();
        LOG.debug("ContentType for request with URI: \"{}\"", (Object)contentType);
        if (this.contentTypes != null && this.contentTypes.contains(contentType)) {
            LOG.debug("Processing request {}.", (Object)request.getRequestURI());
            filterChain.doFilter((ServletRequest)new NfcRequest(request, this.contentTypes), (ServletResponse)response);
        } else {
            LOG.debug("Skip processing of HTTP request since it's content type \"{}\" is not in whitelist.", (Object)contentType);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

