/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.shared.security;

import io.muenchendigital.digiwf.shared.security.UserAuthenticationProvider;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class RequestResponseLoggingFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RequestResponseLoggingFilter.class);
    private static final String REQUEST_LOGGING_MODE_ALL = "all";
    private static final String REQUEST_LOGGING_MODE_CHANGING = "changing";
    private static final List<String> CHANGING_METHODS = Arrays.asList("POST", "PUT", "PATCH", "DELETE");
    @Value(value="${security.logging.requests:}")
    private String requestLoggingMode;
    @Autowired
    private UserAuthenticationProvider userAuthenticationProvider;

    public void init(FilterConfig filterConfig) throws ServletException {
        log.debug("Initializing filter: {}", (Object)this);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.checkForLogging(httpRequest)) {
            log.info("User {} executed {} on URI {}", new Object[]{this.userAuthenticationProvider.getLoggedInUser(), httpRequest.getMethod(), httpRequest.getRequestURI()});
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        log.debug("Destructing filter: {}", (Object)this);
    }

    private boolean checkForLogging(HttpServletRequest httpServletRequest) {
        return this.requestLoggingMode.equals(REQUEST_LOGGING_MODE_ALL) || this.requestLoggingMode.equals(REQUEST_LOGGING_MODE_CHANGING) && CHANGING_METHODS.contains(httpServletRequest.getMethod());
    }
}

