/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.shared.security;

import io.muenchendigital.digiwf.shared.security.UserAuthenticationProvider;
import org.springframework.context.annotation.Profile;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!no-security"})
public class UserAuthenticationProviderImpl
implements UserAuthenticationProvider {
    private static final String USER_ATTRIBUTE = "user_name";
    public static final String NAME_UNAUTHENTICATED_USER = "unauthenticated";

    public String getLoggedInUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication.getPrincipal() instanceof Jwt) {
            Jwt jwt = (Jwt)authentication.getPrincipal();
            return (String)jwt.getClaims().get(USER_ATTRIBUTE);
        }
        return NAME_UNAUTHENTICATED_USER;
    }
}

