/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.Http2ConnectionBuilder;
import io.muserver.MuServerBuilder;
import io.muserver.MuServerImpl;
import io.muserver.NettyHandlerAdapter;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;

class AlpnHandler
extends ApplicationProtocolNegotiationHandler {
    private final NettyHandlerAdapter nettyHandlerAdapter;
    private final MuServerImpl server;
    private final String proto;

    AlpnHandler(NettyHandlerAdapter nettyHandlerAdapter, MuServerImpl server, String proto) {
        super("http/1.1");
        this.nettyHandlerAdapter = nettyHandlerAdapter;
        this.server = server;
        this.proto = proto;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
    }

    protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
        if ("h2".equals(protocol)) {
            ctx.pipeline().addLast(new ChannelHandler[]{new Http2ConnectionBuilder(this.server, this.nettyHandlerAdapter).build()});
            return;
        }
        if ("http/1.1".equals(protocol)) {
            ctx.pipeline().remove("pressure");
            MuServerBuilder.setupHttp1Pipeline(ctx.pipeline(), this.nettyHandlerAdapter, this.server, this.proto);
            return;
        }
        throw new IllegalStateException("unknown protocol: " + protocol);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ctx.close();
    }

    protected void handshakeFailure(ChannelHandlerContext ctx, Throwable cause) {
        ctx.fireExceptionCaught(cause);
        ctx.close();
    }
}

