/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.AsyncHandle;
import io.muserver.AsyncSsePublisher;
import io.muserver.Mutils;
import io.muserver.ResponseCompleteListener;
import io.muserver.SsePublisherImpl;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;

class AsyncSsePublisherImpl
implements AsyncSsePublisher {
    private final AsyncHandle asyncHandle;
    private volatile boolean closed = false;

    AsyncSsePublisherImpl(AsyncHandle asyncHandle) {
        this.asyncHandle = asyncHandle;
    }

    @Override
    public CompletionStage<?> send(String message) {
        return this.send(message, null, null);
    }

    @Override
    public CompletionStage<?> send(String message, String event) {
        return this.send(message, event, null);
    }

    @Override
    public CompletionStage<?> send(String message, String event, String eventID) {
        return this.write(SsePublisherImpl.dataText(message, event, eventID));
    }

    @Override
    public CompletionStage<?> sendComment(String comment) {
        return this.write(SsePublisherImpl.commentText(comment));
    }

    @Override
    public CompletionStage<?> setClientReconnectTime(long timeToWait, TimeUnit unit) {
        return this.write(SsePublisherImpl.clientReconnectText(timeToWait, unit));
    }

    @Override
    public void setResponseCompleteHandler(ResponseCompleteListener responseCompleteListener) {
        this.asyncHandle.addResponseCompleteHandler(responseCompleteListener);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    private CompletionStage<?> write(String text) {
        CompletableFuture stage = new CompletableFuture();
        if (this.closed) {
            stage.completeExceptionally(new IllegalStateException("The SSE stream was already closed"));
        } else {
            this.asyncHandle.write(Mutils.toByteBuffer(text), error -> {
                if (error == null) {
                    stage.complete(null);
                } else {
                    stage.completeExceptionally(error);
                }
            });
        }
        return stage;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.asyncHandle.complete();
        }
    }
}

