/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.DoneCallback;
import io.muserver.MuWebSocket;
import io.muserver.MuWebSocketSession;
import io.muserver.WebsocketSessionState;
import io.netty.handler.codec.CorruptedFrameException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;

public abstract class BaseWebSocket
implements MuWebSocket {
    private MuWebSocketSession session;

    protected WebsocketSessionState state() {
        MuWebSocketSession session = this.session;
        return session == null ? WebsocketSessionState.NOT_STARTED : session.state();
    }

    @Override
    public void onConnect(MuWebSocketSession session) throws Exception {
        this.session = session;
    }

    @Override
    public void onText(String message, boolean isLast, DoneCallback onComplete) throws Exception {
        onComplete.onComplete(null);
    }

    @Override
    public void onBinary(ByteBuffer buffer, boolean isLast, DoneCallback onComplete) throws Exception {
        onComplete.onComplete(null);
    }

    @Override
    public void onClientClosed(int statusCode, String reason) throws Exception {
        try {
            this.session.close(statusCode, reason);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void onPing(ByteBuffer payload, DoneCallback onComplete) throws Exception {
        this.session().sendPong(payload, onComplete);
    }

    @Override
    public void onPong(ByteBuffer payload, DoneCallback onComplete) throws Exception {
        onComplete.onComplete(null);
    }

    @Override
    public void onError(Throwable cause) throws Exception {
        if (!this.state().endState()) {
            if (cause instanceof TimeoutException) {
                this.session().close(1001, WebsocketSessionState.TIMED_OUT.name());
            } else if (cause instanceof CorruptedFrameException) {
                this.session().close(1008, WebsocketSessionState.ERRORED.name());
            } else if (this.session != null) {
                this.session().close(1011, WebsocketSessionState.ERRORED.name());
            }
        }
    }

    protected MuWebSocketSession session() {
        if (this.session == null) {
            throw new IllegalStateException("The websocket has not been connected yet");
        }
        return this.session;
    }
}

