/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.NettyResponseAdaptor;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.OutputStream;

class ChunkedHttpOutputStream
extends OutputStream {
    private final NettyResponseAdaptor response;
    private boolean isClosed = false;

    ChunkedHttpOutputStream(NettyResponseAdaptor response) {
        this.response = response;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.isClosed) {
            throw new IOException("Cannot write to closed output stream");
        }
        this.response.httpExchange.block(() -> this.response.writeAndFlush(Unpooled.wrappedBuffer((byte[])b, (int)off, (int)len)));
    }

    @Override
    public void close() {
        this.isClosed = true;
    }
}

