/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.ContextHandler;
import io.muserver.Method;
import io.muserver.MuHandler;
import io.muserver.MuHandlerBuilder;
import io.muserver.RouteHandler;
import io.muserver.Routes;
import java.util.ArrayList;
import java.util.List;

public class ContextHandlerBuilder
implements MuHandlerBuilder<ContextHandler> {
    private String path;
    private List<MuHandler> handlers = new ArrayList<MuHandler>();

    public ContextHandlerBuilder withPath(String path) {
        this.path = path;
        return this;
    }

    public static ContextHandlerBuilder context(String path) {
        return new ContextHandlerBuilder().withPath(path);
    }

    public ContextHandlerBuilder addHandler(MuHandlerBuilder handler) {
        if (handler == null) {
            return this;
        }
        return this.addHandler((MuHandler)handler.build());
    }

    public ContextHandlerBuilder addHandler(MuHandler handler) {
        if (handler != null) {
            this.handlers.add(handler);
        }
        return this;
    }

    public ContextHandlerBuilder addHandler(Method method, String uriTemplate, RouteHandler handler) {
        if (handler == null) {
            return this;
        }
        return this.addHandler(Routes.route(method, uriTemplate, handler));
    }

    @Override
    public ContextHandler build() {
        return new ContextHandler(this.path, this.handlers);
    }
}

