/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.CookieBuilder;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Cookie {
    final DefaultCookie nettyCookie;

    Cookie(String name, String value) {
        this.nettyCookie = new DefaultCookie(name, value);
    }

    public String name() {
        return this.nettyCookie.name();
    }

    public String value() {
        return this.nettyCookie.value();
    }

    public String domain() {
        return this.nettyCookie.domain();
    }

    public String path() {
        return this.nettyCookie.path();
    }

    public long maxAge() {
        return this.nettyCookie.maxAge();
    }

    public String sameSite() {
        return this.nettyCookie.sameSite().name();
    }

    public boolean isSecure() {
        return this.nettyCookie.isSecure();
    }

    public boolean isHttpOnly() {
        return this.nettyCookie.isHttpOnly();
    }

    public int hashCode() {
        return this.nettyCookie.hashCode();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Cookie && this.nettyCookie.equals(o);
    }

    public String toString() {
        return this.nettyCookie.toString();
    }

    static List<Cookie> nettyToMu(Set<io.netty.handler.codec.http.cookie.Cookie> originals) {
        return originals.stream().map(n -> new Cookie(n.name(), n.value())).collect(Collectors.toList());
    }

    public static CookieBuilder builder() {
        return CookieBuilder.newSecureCookie();
    }
}

