/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.ForwardedHeader;
import io.muserver.HeaderNames;
import io.muserver.Headers;
import io.muserver.MediaTypeParser;
import io.muserver.ParameterizedHeaderWithValue;
import io.netty.handler.codec.HeadersUtils;
import jakarta.ws.rs.core.MediaType;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class Headtils {
    Headtils() {
    }

    static List<ForwardedHeader> getForwardedHeaders(Headers headers) {
        List<String> all = headers.getAll(HeaderNames.FORWARDED);
        if (all.isEmpty()) {
            List<String> hosts = Headtils.getXForwardedValue(headers, HeaderNames.X_FORWARDED_HOST);
            List<String> ports = Headtils.getXForwardedValue(headers, HeaderNames.X_FORWARDED_PORT);
            List<String> protos = Headtils.getXForwardedValue(headers, HeaderNames.X_FORWARDED_PROTO);
            List<String> fors = Headtils.getXForwardedValue(headers, HeaderNames.X_FORWARDED_FOR);
            int max = Math.max(Math.max(Math.max(hosts.size(), protos.size()), fors.size()), ports.size());
            if (max == 0) {
                return Collections.emptyList();
            }
            ArrayList<ForwardedHeader> results = new ArrayList<ForwardedHeader>();
            boolean includeHost = hosts.size() == max;
            boolean includeProto = protos.size() == max;
            boolean includeFor = fors.size() == max;
            boolean includePort = ports.size() == max;
            String curHost = includePort && !includeHost ? headers.get(HeaderNames.HOST) : null;
            for (int i = 0; i < max; ++i) {
                String hostToUse;
                boolean useDefaultPort;
                String host = includeHost ? hosts.get(i) : null;
                String port = includePort ? ports.get(i) : null;
                String proto = includeProto ? protos.get(i) : null;
                String forValue = includeFor ? fors.get(i) : null;
                boolean bl = useDefaultPort = port == null || proto != null && (proto.equalsIgnoreCase("http") && "80".equals(port) || proto.equalsIgnoreCase("https") && "443".equals(port));
                String string = includeHost ? host : (hostToUse = includePort ? curHost : null);
                if (hostToUse != null && !useDefaultPort) {
                    hostToUse = hostToUse.replaceFirst(":[0-9]+$", "") + ":" + port;
                }
                results.add(new ForwardedHeader(null, forValue, hostToUse, proto, null));
            }
            return results;
        }
        ArrayList<ForwardedHeader> results = new ArrayList<ForwardedHeader>();
        for (String s : all) {
            results.addAll(ForwardedHeader.fromString(s));
        }
        return results;
    }

    private static List<String> getXForwardedValue(Headers headers, CharSequence name) {
        List<String> values = headers.getAll(name);
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        return values.stream().map(v -> v.split("\\s*,\\s*")).flatMap(Arrays::stream).collect(Collectors.toList());
    }

    static List<ParameterizedHeaderWithValue> getParameterizedHeaderWithValues(Headers headers, CharSequence headerName) {
        String input = headers.get(headerName);
        if (input == null) {
            return Collections.emptyList();
        }
        return ParameterizedHeaderWithValue.fromString(input);
    }

    static MediaType getMediaType(Headers headers) {
        String value = headers.get(HeaderNames.CONTENT_TYPE);
        if (value == null) {
            return null;
        }
        return MediaTypeParser.fromString(value);
    }

    static String toString(Headers headers, Collection<String> toSuppress) {
        return HeadersUtils.toString(headers.getClass(), (Iterator)new RedactorIterator(headers.iterator(), toSuppress), (int)headers.size());
    }

    private static class RedactorIterator
    implements Iterator<Map.Entry<String, String>> {
        static final List<String> sensitiveOnes = Arrays.asList(HeaderNames.COOKIE.toString(), HeaderNames.SET_COOKIE.toString(), HeaderNames.AUTHORIZATION.toString());
        private final Iterator<Map.Entry<String, String>> iterator;
        private final Collection<String> toSuppress;

        public RedactorIterator(Iterator<Map.Entry<String, String>> iterator, Collection<String> toSuppress) {
            this.iterator = iterator;
            this.toSuppress = toSuppress == null ? sensitiveOnes : (Collection)toSuppress.stream().map(String::toLowerCase).collect(Collectors.toSet());
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<String, String> next() {
            Map.Entry<String, String> next = this.iterator.next();
            if (this.toSuppress.contains(next.getKey().toLowerCase())) {
                return new AbstractMap.SimpleImmutableEntry<String, String>(next.getKey(), "(hidden)");
            }
            return next;
        }
    }
}

