/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.ForwardedHeader;
import io.muserver.HeaderNames;
import io.muserver.Headers;
import io.muserver.Headtils;
import io.muserver.NettyRequestParameters;
import io.muserver.ParameterizedHeader;
import io.muserver.ParameterizedHeaderWithValue;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.internal.ObjectUtil;
import jakarta.ws.rs.core.MediaType;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class Http1Headers
implements Headers {
    private final HttpHeaders entries;

    Http1Headers() {
        this((HttpHeaders)new DefaultHttpHeaders());
    }

    Http1Headers(HttpHeaders entries) {
        this.entries = entries;
    }

    @Override
    public String get(String name) {
        return this.entries.get(name);
    }

    @Override
    public String get(CharSequence name) {
        return this.entries.get(name);
    }

    @Override
    public String get(CharSequence name, String defaultValue) {
        return this.entries.get(name, defaultValue);
    }

    @Override
    public int getInt(CharSequence name, int defaultValue) {
        return this.entries.getInt(name, defaultValue);
    }

    @Override
    public long getLong(String name, long defaultValue) {
        try {
            String stringVal = this.get(name, null);
            if (stringVal == null) {
                return defaultValue;
            }
            return Long.parseLong(stringVal, 10);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public float getFloat(String name, float defaultValue) {
        try {
            String stringVal = this.get(name, null);
            if (stringVal == null) {
                return defaultValue;
            }
            return Float.parseFloat(stringVal);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public double getDouble(String name, double defaultValue) {
        try {
            String stringVal = this.get(name, null);
            if (stringVal == null) {
                return defaultValue;
            }
            return Double.parseDouble(stringVal);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public boolean getBoolean(String name) {
        String val = this.get(name, "").toLowerCase();
        return NettyRequestParameters.isTruthy(val);
    }

    @Override
    public Long getTimeMillis(CharSequence name) {
        return this.entries.getTimeMillis(name);
    }

    @Override
    public long getTimeMillis(CharSequence name, long defaultValue) {
        return this.entries.getTimeMillis(name, defaultValue);
    }

    @Override
    public List<String> getAll(String name) {
        return this.entries.getAll(name);
    }

    @Override
    public List<String> getAll(CharSequence name) {
        return this.entries.getAll(name);
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        return this.entries.entries();
    }

    @Override
    public boolean contains(String name) {
        return this.entries.contains(name);
    }

    @Override
    public boolean contains(CharSequence name) {
        return this.entries.contains(name);
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.entries.iteratorAsString();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Set<String> names() {
        return this.entries.names();
    }

    @Override
    public Headers add(String name, Object value) {
        this.entries.add(name, value);
        return this;
    }

    @Override
    public Headers add(CharSequence name, Object value) {
        this.entries.add(name, value);
        return this;
    }

    @Override
    public Headers add(String name, Iterable<?> values) {
        this.entries.add(name, values);
        return this;
    }

    @Override
    public Headers add(CharSequence name, Iterable<?> values) {
        this.entries.add(name, values);
        return this;
    }

    @Override
    public Headers add(Headers headers) {
        for (Map.Entry<String, String> e : headers) {
            this.add(e.getKey(), (Object)e.getValue());
        }
        return this;
    }

    @Override
    public Headers addInt(CharSequence name, int value) {
        this.entries.addInt(name, value);
        return this;
    }

    @Override
    public Headers set(String name, Object value) {
        this.entries.set(name, value);
        return this;
    }

    @Override
    public Headers set(CharSequence name, Object value) {
        this.entries.set(name, value);
        return this;
    }

    @Override
    public Headers set(String name, Iterable<?> values) {
        this.entries.set(name, values);
        return this;
    }

    @Override
    public Headers set(CharSequence name, Iterable<?> values) {
        this.entries.set(name, values);
        return this;
    }

    @Override
    public Headers set(Headers headers) {
        ObjectUtil.checkNotNull((Object)headers, (String)"headers");
        this.clear();
        for (Map.Entry<String, String> entry : headers) {
            this.add(entry.getKey(), (Object)entry.getValue());
        }
        return this;
    }

    @Override
    public Headers setAll(Headers headers) {
        ObjectUtil.checkNotNull((Object)headers, (String)"headers");
        for (String name : headers.names()) {
            this.set(name, (Iterable<?>)headers.getAll(name));
        }
        return this;
    }

    @Override
    public Headers setInt(CharSequence name, int value) {
        this.entries.setInt(name, value);
        return this;
    }

    @Override
    public Headers remove(String name) {
        this.entries.remove(name);
        return this;
    }

    @Override
    public Headers remove(CharSequence name) {
        this.entries.remove(name);
        return this;
    }

    @Override
    public Headers clear() {
        this.entries.clear();
        return this;
    }

    @Override
    public boolean contains(String name, String value, boolean ignoreCase) {
        return this.entries.contains(name, value, ignoreCase);
    }

    @Override
    public boolean contains(CharSequence name, CharSequence value, boolean ignoreCase) {
        return this.entries.contains(name, value, ignoreCase);
    }

    @Override
    public boolean containsValue(CharSequence name, CharSequence value, boolean ignoreCase) {
        return this.entries.containsValue(name, value, ignoreCase);
    }

    public boolean equals(Object o) {
        return this.entries.equals(o);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    @Override
    public String toString() {
        return Headtils.toString(this, null);
    }

    @Override
    public String toString(Collection<String> toSuppress) {
        return Headtils.toString(this, toSuppress);
    }

    @Override
    public boolean hasBody() {
        return this.contains(HeaderNames.TRANSFER_ENCODING) || this.getLong(HeaderNames.CONTENT_LENGTH.toString(), -1L) > 0L;
    }

    @Override
    public List<ParameterizedHeaderWithValue> accept() {
        return Headtils.getParameterizedHeaderWithValues(this, HeaderNames.ACCEPT);
    }

    @Override
    public List<ParameterizedHeaderWithValue> acceptCharset() {
        return Headtils.getParameterizedHeaderWithValues(this, HeaderNames.ACCEPT_CHARSET);
    }

    @Override
    public List<ParameterizedHeaderWithValue> acceptEncoding() {
        return Headtils.getParameterizedHeaderWithValues(this, HeaderNames.ACCEPT_ENCODING);
    }

    @Override
    public List<ForwardedHeader> forwarded() {
        return Headtils.getForwardedHeaders(this);
    }

    @Override
    public List<ParameterizedHeaderWithValue> acceptLanguage() {
        return Headtils.getParameterizedHeaderWithValues(this, HeaderNames.ACCEPT_LANGUAGE);
    }

    @Override
    public ParameterizedHeader cacheControl() {
        return ParameterizedHeader.fromString(this.get(HeaderNames.CACHE_CONTROL));
    }

    @Override
    public MediaType contentType() {
        return Headtils.getMediaType(this);
    }
}

