/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.HeaderNames;
import io.muserver.HeaderValues;
import io.muserver.Http1Headers;
import io.muserver.NettyRequestAdapter;
import io.muserver.NettyResponseAdaptor;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.Map;

class Http1Response
extends NettyResponseAdaptor {
    final ChannelHandlerContext ctx;
    private final Http1Headers headers;

    Http1Response(ChannelHandlerContext ctx, NettyRequestAdapter request, Http1Headers headers) {
        super(request, headers);
        this.ctx = ctx;
        this.headers = headers;
    }

    @Override
    protected ChannelFuture startStreaming() {
        NettyResponseAdaptor.EmptyHttpResponse response;
        super.startStreaming();
        NettyResponseAdaptor.EmptyHttpResponse emptyHttpResponse = response = this.isHead ? new NettyResponseAdaptor.EmptyHttpResponse(this.httpStatus()) : new DefaultHttpResponse(HttpVersion.HTTP_1_1, this.httpStatus(), false);
        if (this.declaredLength == -1L) {
            this.headers.set(HeaderNames.TRANSFER_ENCODING, (Object)HeaderValues.CHUNKED);
        }
        this.writeHeaders((HttpResponse)response);
        return this.ctx.write((Object)response);
    }

    @Override
    protected void onContentLengthMismatch() {
        throw new IllegalStateException("The declared content length for " + this.request + " was " + this.declaredLength + " bytes. The current write is being aborted and the connection is being closed because it would have resulted in " + this.bytesStreamed + " bytes being sent.");
    }

    private void writeHeaders(HttpResponse response) {
        HttpHeaders rh = response.headers();
        for (Map.Entry<String, String> header : this.headers) {
            rh.add(header.getKey(), (Object)header.getValue());
        }
    }

    @Override
    ChannelFuture writeAndFlushToChannel(boolean isLast, ByteBuf content) {
        DefaultLastHttpContent msg = isLast ? new DefaultLastHttpContent(content) : new DefaultHttpContent(content);
        return this.ctx.writeAndFlush((Object)msg);
    }

    @Override
    protected ChannelFuture writeFullResponse(ByteBuf body) {
        if (!this.ctx.executor().inEventLoop()) {
            ChannelPromise promise = this.ctx.newPromise();
            this.ctx.executor().submit(() -> this.writeFullResponse(body).addListener(future -> {
                if (future.isSuccess()) {
                    promise.setSuccess();
                } else {
                    promise.setFailure(future.cause());
                }
            }));
            return promise;
        }
        NettyResponseAdaptor.EmptyHttpResponse resp = this.isHead ? new NettyResponseAdaptor.EmptyHttpResponse(this.httpStatus()) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, this.httpStatus(), body, false);
        this.writeHeaders((HttpResponse)resp);
        return this.ctx.writeAndFlush((Object)resp);
    }

    @Override
    protected ChannelFuture sendEmptyResponse(boolean addContentLengthHeader) {
        NettyResponseAdaptor.EmptyHttpResponse msg = this.isHead ? new NettyResponseAdaptor.EmptyHttpResponse(this.httpStatus()) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, this.httpStatus(), false);
        this.writeHeaders((HttpResponse)msg);
        if (addContentLengthHeader) {
            msg.headers().set(HeaderNames.CONTENT_LENGTH, (Object)HeaderValues.ZERO);
        }
        return this.ctx.writeAndFlush((Object)msg);
    }

    @Override
    protected ChannelFuture writeLastContentMarker() {
        return this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
    }

    public String toString() {
        return "Http1Response{outputState=" + (Object)((Object)this.outputState()) + ", status=" + this.status + "}";
    }
}

