/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.ContentTypes;
import io.muserver.DoneCallback;
import io.muserver.HeaderNames;
import io.muserver.HeaderValues;
import io.muserver.Headers;
import io.muserver.Http1Connection;
import io.muserver.Http2ConnectionFlowControl;
import io.muserver.Http2Headers;
import io.muserver.Http2Response;
import io.muserver.Http2To1RequestAdapter;
import io.muserver.HttpConnection;
import io.muserver.HttpExchange;
import io.muserver.HttpExchangeState;
import io.muserver.InvalidHttpRequestException;
import io.muserver.Method;
import io.muserver.MuExceptionFiredEvent;
import io.muserver.MuRequest;
import io.muserver.MuServer;
import io.muserver.MuServerImpl;
import io.muserver.MuStatsImpl;
import io.muserver.MuWebSocket;
import io.muserver.Mutils;
import io.muserver.NettyHandlerAdapter;
import io.muserver.NettyRequestAdapter;
import io.muserver.ParameterizedHeaderWithValue;
import io.muserver.RedirectException;
import io.muserver.RequestState;
import io.muserver.ResponseState;
import io.muserver.ServerSettings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Http2Connection
extends Http2ConnectionFlowControl
implements HttpConnection {
    private static final Logger log = LoggerFactory.getLogger(Http2Connection.class);
    private final MuServerImpl server;
    private final NettyHandlerAdapter nettyHandlerAdapter;
    private final ConcurrentHashMap<Integer, HttpExchange> exchanges = new ConcurrentHashMap();
    private volatile int lastStreamId = 0;
    private final MuStatsImpl connectionStats = new MuStatsImpl(null);
    private InetSocketAddress remoteAddress;
    private final Instant startTime = Instant.now();
    private ChannelHandlerContext nettyContext;

    Http2Connection(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, MuServerImpl server, NettyHandlerAdapter nettyHandlerAdapter) {
        super(decoder, encoder, initialSettings);
        this.server = server;
        this.nettyHandlerAdapter = nettyHandlerAdapter;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.server.stats.onConnectionOpened();
        this.remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        this.nettyContext = ctx;
        this.server.onConnectionStarted(this);
        super.handlerAdded(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.server.stats.onConnectionClosed();
        this.server.onConnectionEnded(this);
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.error("exception caught!", cause);
        this.closeAllAndDisconnect(ctx, Http2Error.INTERNAL_ERROR, ResponseState.ERRORED);
    }

    private void closeAllAndDisconnect(ChannelHandlerContext ctx, Http2Error error, ResponseState reason) {
        if (error != null) {
            this.encoder().writeGoAway(ctx, this.lastStreamId, error.code(), Unpooled.EMPTY_BUFFER, ctx.channel().voidPromise());
        }
        this.cleanup();
        ctx.close();
    }

    private ChannelFuture sendSimpleResponse(ChannelHandlerContext ctx, int streamId, String message, int code) {
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.status((CharSequence)String.valueOf(code));
        byte[] bytes = message.getBytes(StandardCharsets.UTF_8);
        ByteBuf content = Unpooled.copiedBuffer((byte[])bytes);
        headers.set((Object)HeaderNames.DATE, (Object)Mutils.toHttpDate(new Date()));
        headers.set((Object)HeaderNames.CONTENT_TYPE, (Object)ContentTypes.TEXT_PLAIN_UTF8);
        headers.set((Object)HeaderNames.CONTENT_LENGTH, (Object)String.valueOf(bytes.length));
        this.encoder().writeHeaders(ctx, streamId, (io.netty.handler.codec.http2.Http2Headers)headers, 0, false, ctx.voidPromise());
        return Http2Response.writeAndFlushToChannel(ctx, this.encoder(), streamId, content, true);
    }

    private ChannelFuture sendRedirect(ChannelHandlerContext ctx, int streamId, URI locationHeader) {
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.status((CharSequence)String.valueOf(302));
        headers.set((Object)HeaderNames.DATE, (Object)Mutils.toHttpDate(new Date()));
        headers.set((Object)HeaderNames.LOCATION, (Object)locationHeader.toString());
        ChannelFuture future = this.encoder().writeHeaders(ctx, streamId, (io.netty.handler.codec.http2.Http2Headers)headers, 0, true, ctx.voidPromise());
        ctx.channel().flush();
        return future;
    }

    @Override
    protected void cleanStream(int streamId) {
        super.cleanStream(streamId);
        this.exchanges.remove(streamId);
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        if (!this.exchanges.isEmpty()) {
            for (Integer streamId : this.exchanges.keySet()) {
                this.cancelExchange(streamId);
            }
        }
    }

    @Override
    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) {
        if (!this.exchanges.containsKey(streamId)) {
            super.cleanBuffer(streamId);
            return data.readableBytes() + padding;
        }
        return super.onDataRead(ctx, streamId, data, padding, endOfStream);
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, io.netty.handler.codec.http2.Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        this.lastStreamId = streamId;
        try {
            boolean hasRequestBody;
            HttpMethod nettyMeth = HttpMethod.valueOf((String)headers.method().toString().toUpperCase());
            Method muMethod = HttpExchange.getMethod(nettyMeth);
            String uri = HttpExchange.getRelativeUrl(headers.path().toString());
            ServerSettings settings = this.server.settings();
            if (uri.length() > settings.maxUrlSize) {
                throw new InvalidHttpRequestException(414, "414 Request-URI Too Long");
            }
            Http2To1RequestAdapter nettyReq = new Http2To1RequestAdapter(streamId, nettyMeth, uri, headers);
            boolean bl = hasRequestBody = !endOfStream;
            if (hasRequestBody) {
                long bodyLen = headers.getLong((Object)HeaderNames.CONTENT_LENGTH, -1L);
                if (bodyLen == 0L) {
                    hasRequestBody = false;
                } else if (bodyLen > settings.maxRequestSize) {
                    throw new InvalidHttpRequestException(413, "413 Payload Too Large");
                }
            }
            Http2Headers muHeaders = new Http2Headers(headers, hasRequestBody);
            String host = headers.authority().toString();
            muHeaders.set(HeaderNames.HOST, (Object)host);
            NettyRequestAdapter muReq = new NettyRequestAdapter(ctx, nettyReq, muHeaders, muMethod, "https", uri, host);
            Http2Response resp = new Http2Response(ctx, muReq, new Http2Headers(), this.encoder(), streamId, settings);
            HttpExchange httpExchange = new HttpExchange(this, ctx, muReq, resp, streamId);
            resp.setExchange(httpExchange);
            muReq.setExchange(httpExchange);
            if (settings.block(muReq)) {
                throw new InvalidHttpRequestException(429, "429 Too Many Requests");
            }
            resp.addChangeListener((exchange, newState) -> {
                if (newState.endState()) {
                    this.nettyHandlerAdapter.onResponseComplete(exchange, this.server.stats, this.connectionStats);
                }
            });
            this.exchanges.put(streamId, httpExchange);
            httpExchange.addChangeListener((exchange, newState) -> {
                if (newState.endState()) {
                    muReq.cleanup();
                    this.cleanStream(streamId);
                    if (newState == HttpExchangeState.ERRORED) {
                        this.resetStream(ctx, streamId, Http2Error.INTERNAL_ERROR.code(), ctx.voidPromise());
                        ctx.flush();
                    }
                }
            });
            muReq.addChangeListener((exchange, newState) -> {
                if (newState == RequestState.RECEIVING_BODY) {
                    this.read(ctx, streamId);
                }
            });
            if (endOfStream) {
                muReq.setState(RequestState.COMPLETE);
                super.onDataRead(ctx, streamId, Unpooled.EMPTY_BUFFER, 0, true);
            }
            try {
                this.server.stats.onRequestStarted(httpExchange.request);
                this.connectionStats.onRequestStarted(httpExchange.request);
                this.nettyHandlerAdapter.onHeaders(httpExchange);
            }
            catch (RejectedExecutionException e) {
                this.server.stats.onRequestEnded(httpExchange.request);
                this.connectionStats.onRequestEnded(httpExchange.request);
                log.warn("Could not service " + httpExchange.request + " because the thread pool is full so sending a 503");
                throw new InvalidHttpRequestException(503, "503 Service Unavailable");
            }
        }
        catch (InvalidHttpRequestException ihr) {
            if (ihr.code == 429 || ihr.code == 503) {
                this.connectionStats.onRejectedDueToOverload();
                this.server.stats.onRejectedDueToOverload();
            } else {
                this.connectionStats.onInvalidRequest();
                this.server.stats.onInvalidRequest();
            }
            this.sendSimpleResponse(ctx, streamId, ihr.getMessage(), ihr.code);
        }
        catch (RedirectException e) {
            this.sendRedirect(ctx, streamId, e.location);
        }
    }

    @Override
    public void onDataRead0(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) {
        int dataSize = data.readableBytes();
        int consumed = dataSize + padding;
        boolean empty = dataSize == 0;
        HttpExchange httpExchange = this.exchanges.get(streamId);
        if (httpExchange == null) {
            log.debug("Got a chunk of message for an unknown request. This can happen when a request is rejected based on headers, and then the rejected body arrives.");
        } else {
            Object msg = endOfStream ? (empty ? DefaultLastHttpContent.EMPTY_LAST_CONTENT : new DefaultLastHttpContent(data, false)) : new DefaultHttpContent(data);
            data.retain();
            DoneCallback doneCallback = error -> {
                Http2Stream stream = this.connection().stream(streamId);
                if (stream != null && this.decoder().flowController().consumeBytes(stream, consumed)) {
                    ctx.flush();
                }
                data.release();
                if (error != null) {
                    ctx.fireUserEventTriggered((Object)new MuExceptionFiredEvent(httpExchange, streamId, error));
                } else if (!endOfStream) {
                    this.read(ctx, streamId);
                }
            };
            httpExchange.onMessage(ctx, msg, error -> {
                if (ctx.executor().inEventLoop()) {
                    doneCallback.onComplete(error);
                } else {
                    ctx.executor().execute(() -> {
                        try {
                            doneCallback.onComplete(error);
                        }
                        catch (Exception e) {
                            log.debug("Error from doneCallback, e");
                        }
                    });
                }
            });
        }
    }

    protected void onStreamError(ChannelHandlerContext ctx, boolean outbound, Throwable cause, Http2Exception.StreamException http2Ex) {
        HttpExchange httpExchange = this.exchanges.get(http2Ex.streamId());
        if (httpExchange != null) {
            Throwable toy = cause;
            while (toy instanceof Http2Exception) {
                toy = toy.getCause();
            }
            if (toy == null) {
                toy = cause;
            }
            try {
                if (httpExchange.onException(ctx, toy)) {
                    super.onStreamError(ctx, outbound, cause, http2Ex);
                }
            }
            catch (Throwable e) {
                log.warn("Unexpected exception for " + httpExchange + " .onException " + toy, e);
                super.onStreamError(ctx, outbound, cause, http2Ex);
            }
        } else {
            super.onStreamError(ctx, outbound, cause, http2Ex);
        }
    }

    static CharSequence compressionToUse(Headers requestHeaders) {
        for (ParameterizedHeaderWithValue encVal : requestHeaders.acceptEncoding()) {
            String enc = encVal.value();
            if (HttpHeaderValues.GZIP.contentEqualsIgnoreCase((CharSequence)enc)) {
                return HeaderValues.GZIP;
            }
            if (!HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase((CharSequence)enc)) continue;
            return HeaderValues.DEFLATE;
        }
        return null;
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, io.netty.handler.codec.http2.Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        this.onHeadersRead(ctx, streamId, headers, padding, endOfStream);
    }

    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) {
        this.cancelExchange(streamId);
    }

    private void cancelExchange(int streamId) {
        HttpExchange httpExchange = this.exchanges.get(streamId);
        if (httpExchange != null) {
            httpExchange.onCancelled(ResponseState.ERRORED);
        }
    }

    public void onSettingsAckRead(ChannelHandlerContext ctx) {
    }

    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) {
    }

    public void onPingRead(ChannelHandlerContext ctx, long data) {
    }

    public void onPingAckRead(ChannelHandlerContext ctx, long data) {
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, io.netty.handler.codec.http2.Http2Headers headers, int padding) {
    }

    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) {
        this.closeAllAndDisconnect(ctx, null, ResponseState.CLIENT_DISCONNECTED);
    }

    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
    }

    public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) {
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent ise = (IdleStateEvent)evt;
            if (ise.state() != IdleState.READER_IDLE) {
                log.info("Closed idle connection to " + this.remoteAddress);
                this.closeAllAndDisconnect(ctx, Http2Error.NO_ERROR, ResponseState.TIMED_OUT);
            }
        } else if (evt instanceof MuExceptionFiredEvent) {
            MuExceptionFiredEvent mefe = (MuExceptionFiredEvent)evt;
            Throwable error = mefe.error;
            if (mefe.streamId > 0) {
                error = Http2Exception.streamError((int)mefe.streamId, (Http2Error)Http2Error.INTERNAL_ERROR, (Throwable)error, (String)"Error handling %s", (Object[])new Object[]{mefe.exchange});
            }
            this.onError(ctx, false, error);
        }
        super.userEventTriggered(ctx, evt);
    }

    @Override
    public String protocol() {
        return "HTTP/2";
    }

    @Override
    public boolean isHttps() {
        return true;
    }

    @Override
    public String httpsProtocol() {
        return Http1Connection.getSslSession(this.nettyContext).getProtocol();
    }

    @Override
    public String cipher() {
        return Http1Connection.getSslSession(this.nettyContext).getCipherSuite();
    }

    @Override
    public Instant startTime() {
        return this.startTime;
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public long completedRequests() {
        return this.connectionStats.completedRequests();
    }

    @Override
    public long invalidHttpRequests() {
        return this.connectionStats.invalidHttpRequests();
    }

    @Override
    public long rejectedDueToOverload() {
        return this.connectionStats.rejectedDueToOverload();
    }

    @Override
    public Set<MuRequest> activeRequests() {
        return this.connectionStats.activeRequests();
    }

    @Override
    public Set<MuWebSocket> activeWebsockets() {
        return Collections.emptySet();
    }

    @Override
    public MuServer server() {
        return this.server;
    }

    @Override
    public Optional<Certificate> clientCertificate() {
        return Http1Connection.fromContext(this.nettyContext);
    }
}

