/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.Http2Connection;
import io.muserver.MuCompressorHttp2ConnectionEncoder;
import io.muserver.MuGzipHttp2ConnectionEncoder;
import io.muserver.MuServerImpl;
import io.muserver.NettyHandlerAdapter;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Settings;

class Http2ConnectionBuilder
extends AbstractHttp2ConnectionHandlerBuilder<Http2Connection, Http2ConnectionBuilder> {
    private final MuServerImpl server;
    private final NettyHandlerAdapter nettyHandlerAdapter;

    Http2ConnectionBuilder(MuServerImpl server, NettyHandlerAdapter nettyHandlerAdapter) {
        this.server = server;
        this.nettyHandlerAdapter = nettyHandlerAdapter;
    }

    public Http2Connection build() {
        this.initialSettings().maxHeaderListSize((long)this.server.settings().maxHeadersSize);
        return (Http2Connection)super.build();
    }

    protected Http2Connection build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
        if (this.server.settings().gzipEnabled) {
            MuGzipHttp2ConnectionEncoder delegate = new MuGzipHttp2ConnectionEncoder((Http2ConnectionEncoder)encoder);
            encoder = new MuCompressorHttp2ConnectionEncoder(delegate, 6, 15, 8);
        }
        Http2Connection handler = new Http2Connection(decoder, (Http2ConnectionEncoder)encoder, initialSettings, this.server, this.nettyHandlerAdapter);
        this.frameListener(handler);
        return handler;
    }
}

