/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Settings;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

abstract class Http2ConnectionFlowControl
extends Http2ConnectionHandler
implements Http2FrameListener {
    private final Map<Integer, Queue<DataReadData>> buffer = new HashMap<Integer, Queue<DataReadData>>();
    private final Map<Integer, Boolean> wantsToRead = new HashMap<Integer, Boolean>();

    protected Http2ConnectionFlowControl(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
        super(decoder, encoder, initialSettings);
    }

    protected void read(ChannelHandlerContext ctx, int streamId) {
        if (!ctx.executor().inEventLoop()) {
            ctx.executor().execute(() -> this.read(ctx, streamId));
            return;
        }
        this.wantsToRead.put(streamId, true);
        ctx.executor().submit(() -> this.sendItMaybe(ctx, streamId));
    }

    private void sendItMaybe(ChannelHandlerContext ctx, int streamId) {
        DataReadData msg;
        Queue<DataReadData> queue;
        Boolean wantsIt;
        if (ctx.channel().isActive() && (wantsIt = this.wantsToRead.get(streamId)) != null && wantsIt.booleanValue() && (queue = this.buffer.get(streamId)) != null && (msg = queue.poll()) != null) {
            this.wantsToRead.put(streamId, false);
            this.onDataRead0(ctx, streamId, msg.data, msg.padding, msg.endOfStream);
            msg.data.release();
        }
    }

    protected abstract void onDataRead0(ChannelHandlerContext var1, int var2, ByteBuf var3, int var4, boolean var5);

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) {
        Queue buf = this.buffer.computeIfAbsent(streamId, integer -> new LinkedList());
        buf.add(new DataReadData(data.retain(), padding, endOfStream));
        this.sendItMaybe(ctx, streamId);
        return 0;
    }

    protected void cleanup() {
        if (!this.wantsToRead.isEmpty()) {
            this.wantsToRead.clear();
        }
        if (this.buffer.size() > 0) {
            for (Queue<DataReadData> value : this.buffer.values()) {
                for (DataReadData dataReadData : value) {
                    dataReadData.data.release();
                }
            }
            this.buffer.clear();
        }
    }

    protected void cleanStream(int streamId) {
        this.wantsToRead.remove(streamId);
        this.cleanBuffer(streamId);
    }

    protected void cleanBuffer(int streamId) {
        Queue<DataReadData> removed = this.buffer.remove(streamId);
        if (removed != null && !removed.isEmpty()) {
            for (DataReadData dat : removed) {
                dat.data.release();
            }
            removed.clear();
        }
    }

    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        this.cleanup();
        super.handlerRemoved0(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.cleanup();
        super.channelInactive(ctx);
    }

    private static class DataReadData {
        private final ByteBuf data;
        private final int padding;
        private final boolean endOfStream;

        private DataReadData(ByteBuf data, int padding, boolean endOfStream) {
            this.data = data;
            this.padding = padding;
            this.endOfStream = endOfStream;
        }
    }
}

