/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.HeaderNames;
import io.muserver.HeaderValues;
import io.muserver.Http2Connection;
import io.muserver.Http2Headers;
import io.muserver.NettyRequestAdapter;
import io.muserver.NettyResponseAdaptor;
import io.muserver.ServerSettings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;

class Http2Response
extends NettyResponseAdaptor {
    private final ChannelHandlerContext ctx;
    private final Http2Headers headers;
    private final Http2ConnectionEncoder encoder;
    private final int streamId;
    private final ServerSettings settings;

    Http2Response(ChannelHandlerContext ctx, NettyRequestAdapter request, Http2Headers headers, Http2ConnectionEncoder encoder, int streamId, ServerSettings settings) {
        super(request, headers);
        this.ctx = ctx;
        this.headers = headers;
        this.encoder = encoder;
        this.streamId = streamId;
        this.settings = settings;
    }

    @Override
    protected ChannelFuture writeAndFlushToChannel(boolean isLast, ByteBuf content) {
        return Http2Response.writeAndFlushToChannel(this.ctx, this.encoder, this.streamId, content, isLast);
    }

    static ChannelFuture writeAndFlushToChannel(ChannelHandlerContext ctx, Http2ConnectionEncoder encoder, int streamId, ByteBuf content, boolean isLast) {
        assert (ctx.executor().inEventLoop()) : "Not in event loop";
        ChannelPromise channelPromise = ctx.newPromise();
        encoder.writeData(ctx, streamId, content, 0, isLast, channelPromise);
        ctx.channel().flush();
        return channelPromise;
    }

    @Override
    protected ChannelFuture startStreaming() {
        super.startStreaming();
        return this.writeHeaders(false);
    }

    @Override
    protected void onContentLengthMismatch() {
        throw new IllegalStateException("The declared content length for " + this.request + " was " + this.declaredLength + " bytes. The current write is being aborted and the connection is being closed because it would have resulted in " + this.bytesStreamed + " bytes being sent.");
    }

    private ChannelFuture writeHeaders(boolean isEnd) {
        assert (this.ctx.executor().inEventLoop()) : "Not in event loop";
        this.headers.entries.status((CharSequence)this.httpStatus().codeAsText());
        if (this.settings.shouldCompress(this.headers.get(HeaderNames.CONTENT_LENGTH), this.headers.get(HeaderNames.CONTENT_TYPE))) {
            this.headers.set(HeaderNames.VARY, (Object)Http2Response.getVaryWithAE(this.headers.get(HeaderNames.VARY)));
            CharSequence toUse = Http2Connection.compressionToUse(this.request.headers());
            if (toUse != null && !this.headers.entries.contains((Object)HeaderNames.CONTENT_ENCODING)) {
                this.headers.set(HeaderNames.CONTENT_ENCODING, (Object)("mu-" + toUse));
            }
        }
        ChannelFuture future = this.encoder.writeHeaders(this.ctx, this.streamId, this.headers.entries, 0, isEnd, this.ctx.voidPromise());
        if (isEnd) {
            this.ctx.channel().flush();
        }
        return future;
    }

    @Override
    protected ChannelFuture writeFullResponse(ByteBuf body) {
        this.writeHeaders(false);
        return this.writeAndFlushToChannel(true, body);
    }

    @Override
    protected ChannelFuture writeLastContentMarker() {
        return this.writeAndFlushToChannel(true, Unpooled.directBuffer((int)0));
    }

    @Override
    protected ChannelFuture sendEmptyResponse(boolean addContentLengthHeader) {
        if (addContentLengthHeader) {
            this.headers.set(HeaderNames.CONTENT_LENGTH, (Object)HeaderValues.ZERO);
        }
        return this.writeHeaders(true);
    }

    public String toString() {
        return "Http2Response{outputState=" + (Object)((Object)this.outputState()) + ", status=" + this.status + "}";
    }
}

