/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.MuException;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;

class Http2To1RequestAdapter
implements HttpRequest {
    private final HttpMethod nettyMeth;
    private final String uri;
    private final Http2Headers headers;
    private final int streamId;
    private HttpHeaders http1Headers;

    Http2To1RequestAdapter(int streamId, HttpMethod nettyMeth, String uri, Http2Headers headers) {
        this.streamId = streamId;
        this.nettyMeth = nettyMeth;
        this.uri = uri;
        this.headers = headers;
    }

    @Deprecated
    public HttpMethod getMethod() {
        return this.nettyMeth;
    }

    public HttpMethod method() {
        return this.nettyMeth;
    }

    public HttpRequest setMethod(HttpMethod method) {
        throw new IllegalStateException("Can't set stuff");
    }

    @Deprecated
    public String getUri() {
        return this.uri;
    }

    public String uri() {
        return this.uri;
    }

    public HttpRequest setUri(String uri) {
        throw new IllegalStateException("Can't set stuff");
    }

    public HttpRequest setProtocolVersion(HttpVersion version) {
        throw new IllegalStateException("Can't set stuff");
    }

    @Deprecated
    public HttpVersion getProtocolVersion() {
        return HttpVersion.valueOf((String)"HTTP/2.0");
    }

    public HttpVersion protocolVersion() {
        return new HttpVersion("HTTP/2.0", true);
    }

    public HttpHeaders headers() {
        if (this.http1Headers == null) {
            DefaultHttpHeaders adapter = new DefaultHttpHeaders();
            try {
                HttpConversionUtil.addHttp2ToHttpHeaders((int)this.streamId, (Http2Headers)this.headers, (HttpHeaders)adapter, (HttpVersion)HttpVersion.HTTP_1_1, (boolean)false, (boolean)true);
            }
            catch (Http2Exception e) {
                throw new MuException("Error while preparing headers for multipart form upload");
            }
            this.http1Headers = adapter;
        }
        return this.http1Headers;
    }

    @Deprecated
    public DecoderResult getDecoderResult() {
        return DecoderResult.SUCCESS;
    }

    public DecoderResult decoderResult() {
        return DecoderResult.SUCCESS;
    }

    public void setDecoderResult(DecoderResult result) {
        throw new IllegalStateException("Can't set stuff");
    }
}

