/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.ClientDisconnectedException;
import io.muserver.ContentTypes;
import io.muserver.DoneCallback;
import io.muserver.Exchange;
import io.muserver.HeaderNames;
import io.muserver.HeaderValues;
import io.muserver.Http1Connection;
import io.muserver.Http1Headers;
import io.muserver.Http1Response;
import io.muserver.HttpConnection;
import io.muserver.HttpExchangeState;
import io.muserver.HttpExchangeStateChangeListener;
import io.muserver.InvalidHttpRequestException;
import io.muserver.Method;
import io.muserver.MuException;
import io.muserver.MuExceptionFiredEvent;
import io.muserver.MuRequest;
import io.muserver.MuResponse;
import io.muserver.MuServerImpl;
import io.muserver.MuStatsImpl;
import io.muserver.Mutils;
import io.muserver.NettyHandlerAdapter;
import io.muserver.NettyRequestAdapter;
import io.muserver.NettyResponseAdaptor;
import io.muserver.RedirectException;
import io.muserver.RequestState;
import io.muserver.RequestStateChangeListener;
import io.muserver.ResponseInfo;
import io.muserver.ResponseState;
import io.muserver.ServerSettings;
import io.muserver.UnexpectedMessageException;
import io.muserver.rest.MuRuntimeDelegate;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ScheduledFuture;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpExchange
implements ResponseInfo,
Exchange {
    private static final Map<String, String> exceptionMessageMap = new HashMap<String, String>();
    private static final Logger log;
    final ChannelHandlerContext ctx;
    final NettyRequestAdapter request;
    final NettyResponseAdaptor response;
    private final int streamId;
    private final HttpConnection connection;
    private final long startTime = System.currentTimeMillis();
    private volatile long endTime;
    private volatile HttpExchangeState state = HttpExchangeState.IN_PROGRESS;
    private final List<HttpExchangeStateChangeListener> listeners = new CopyOnWriteArrayList<HttpExchangeStateChangeListener>();
    private ScheduledFuture<?> readTimer;

    boolean inLoop() {
        return this.ctx.executor().inEventLoop();
    }

    void block(Runnable runnable) {
        assert (!this.inLoop()) : "Should not be blocking on the event loop";
        Future task = this.ctx.executor().submit(runnable);
        try {
            task.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedIOException(new InterruptedIOException("Interrupted while writing"));
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new MuException("Error while writing response", cause);
        }
    }

    void block(Callable<ChannelFuture> callable) {
        assert (!this.inLoop()) : "Should not be blocking on the event loop";
        Future task = this.ctx.executor().submit(callable);
        try {
            ((ChannelFuture)task.get()).sync();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedIOException(new InterruptedIOException("Interrupted while writing"));
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new MuException("Error while writing response", cause);
        }
    }

    HttpExchange(HttpConnection connection, ChannelHandlerContext ctx, NettyRequestAdapter request, NettyResponseAdaptor response, int streamId) {
        this.connection = connection;
        this.ctx = ctx;
        this.request = request;
        this.response = response;
        this.streamId = streamId;
        request.addChangeListener((HttpExchange exchange, RequestState newState) -> this.onReqOrRespStateChange(newState, null));
        response.addChangeListener((HttpExchange exchange, ResponseState newState) -> this.onReqOrRespStateChange(null, newState));
    }

    void addChangeListener(HttpExchangeStateChangeListener listener) {
        this.listeners.add(listener);
    }

    private void onReqOrRespStateChange(RequestState requestChanged, ResponseState responseChanged) {
        RequestState reqState = this.request.requestState();
        ResponseState respState = this.response.responseState();
        if (reqState.endState() && respState == ResponseState.UPGRADED) {
            this.onEnded(HttpExchangeState.UPGRADED);
        } else if (reqState.endState() && respState.endState()) {
            HttpExchangeState newState = reqState == RequestState.ERRORED || !respState.completedSuccessfully() ? HttpExchangeState.ERRORED : HttpExchangeState.COMPLETE;
            this.onEnded(newState);
        } else if (responseChanged != null && responseChanged.endState()) {
            this.request.discardInputStreamIfNotConsumed();
        }
    }

    private void onEnded(HttpExchangeState endState) {
        if (this.state.endState()) {
            throw new IllegalStateException("Cannot end an exchange that was already ended. Previous state=" + (Object)((Object)this.state) + "; new state=" + (Object)((Object)endState));
        }
        this.state = endState;
        this.endTime = System.currentTimeMillis();
        for (HttpExchangeStateChangeListener listener : this.listeners) {
            listener.onStateChange(this, endState);
        }
    }

    public void complete() {
        assert (this.inLoop()) : "Not in NIO event loop";
        if (!this.response.outputState().endState()) {
            this.response.complete();
        } else {
            log.debug("Complete called twice for " + this.request);
        }
    }

    void onCancelled(ResponseState reason) {
        this.cancelReadTimeout();
        if (!this.response.outputState().endState()) {
            this.response.onCancelled(reason);
            this.request.onCancelled(reason, new MuException("Cancelled: " + reason.name()));
        } else {
            log.warn("Cancelled called after end state was " + (Object)((Object)this.response.outputState()));
        }
    }

    @Override
    public long duration() {
        long end = this.endTime;
        if (end == 0L) {
            end = System.currentTimeMillis();
        }
        return end - this.request.startTime();
    }

    @Override
    public boolean completedSuccessfully() {
        return this.state.endState() && this.state != HttpExchangeState.ERRORED && this.response.outputState().completedSuccessfully();
    }

    @Override
    public MuRequest request() {
        return this.request;
    }

    @Override
    public MuResponse response() {
        return this.response;
    }

    public String toString() {
        return "ResponseInfo{request=" + this.request + ", response=" + this.response + '}';
    }

    @Override
    public void onMessage(ChannelHandlerContext ctx, Object msg, DoneCallback doneCallback) throws UnexpectedMessageException {
        if (!(msg instanceof HttpContent)) {
            throw new UnexpectedMessageException(this, msg);
        }
        this.cancelReadTimeout();
        HttpContent content = (HttpContent)msg;
        ByteBuf byteBuf = content.content().retain();
        boolean last = msg instanceof LastHttpContent;
        DoneCallback onDone = error -> {
            byteBuf.release();
            try {
                Runnable cleanup = () -> {
                    boolean requestInProgress;
                    boolean bl = requestInProgress = !this.request.requestState().endState();
                    if (error == null) {
                        if (requestInProgress) {
                            if (last) {
                                this.request.setState(RequestState.COMPLETE);
                            } else {
                                this.scheduleReadTimeout();
                            }
                        }
                    } else if (requestInProgress) {
                        this.request.onCancelled(ResponseState.ERRORED, error);
                    }
                };
                if (ctx.executor().inEventLoop()) {
                    cleanup.run();
                } else {
                    ctx.executor().execute(cleanup);
                }
            }
            finally {
                doneCallback.onComplete(error);
            }
        };
        try {
            this.request.onRequestBodyRead(byteBuf, last, onDone);
        }
        catch (Exception e) {
            try {
                onDone.onComplete(e);
            }
            catch (Exception exception) {
                log.error("Unhandled callback error", (Throwable)exception);
            }
        }
    }

    void scheduleReadTimeout() {
        this.cancelReadTimeout();
        long delay = this.connection.server().requestIdleTimeoutMillis();
        this.readTimer = this.ctx.executor().schedule(this.request::onReadTimeout, delay, TimeUnit.MILLISECONDS);
    }

    private void cancelReadTimeout() {
        ScheduledFuture<?> rt = this.readTimer;
        if (rt != null) {
            this.readTimer = null;
            rt.cancel(false);
        }
    }

    @Override
    public void onIdleTimeout(ChannelHandlerContext ctx, IdleStateEvent ise) {
        if (ise.state() == IdleState.ALL_IDLE) {
            this.onCancelled(ResponseState.TIMED_OUT);
            log.info("Closed " + this.request + " (from " + this.request.remoteAddress() + ") because the idle timeout specified in MuServerBuilder#withIdleTimeout is exceeded.");
        }
    }

    @Override
    public HttpConnection connection() {
        return this.connection;
    }

    @Override
    public void onUpgradeComplete(ChannelHandlerContext ctx) {
        throw new UnsupportedOperationException("Cannot upgrade to an HttpExchange");
    }

    public HttpExchangeState state() {
        return this.state;
    }

    static HttpExchange create(MuServerImpl server, String proto, ChannelHandlerContext ctx, Http1Connection connection, HttpRequest nettyRequest, NettyHandlerAdapter nettyHandlerAdapter, MuStatsImpl connectionStats, RequestStateChangeListener requestStateChangeListener, HttpExchangeStateChangeListener stateChangeListener) throws InvalidHttpRequestException, RedirectException {
        ServerSettings settings = server.settings();
        HttpExchange.throwIfInvalid(settings, ctx, nettyRequest);
        Method method = HttpExchange.getMethod(nettyRequest.method());
        Http1Headers headers = new Http1Headers(nettyRequest.headers());
        String relativeUri = HttpExchange.getRelativeUrl(nettyRequest.uri());
        NettyRequestAdapter muRequest = new NettyRequestAdapter(ctx, nettyRequest, headers, method, proto, relativeUri, headers.get(HeaderNames.HOST));
        MuStatsImpl serverStats = server.stats;
        Http1Response muResponse = new Http1Response(ctx, muRequest, new Http1Headers());
        HttpExchange httpExchange = new HttpExchange(connection, ctx, muRequest, muResponse, -1);
        muRequest.setExchange(httpExchange);
        muResponse.setExchange(httpExchange);
        if (settings.block(muRequest)) {
            throw new InvalidHttpRequestException(429, "429 Too Many Requests");
        }
        httpExchange.addChangeListener(stateChangeListener);
        muRequest.addChangeListener(requestStateChangeListener);
        try {
            serverStats.onRequestStarted(httpExchange.request);
            connectionStats.onRequestStarted(httpExchange.request);
            nettyHandlerAdapter.onHeaders(httpExchange);
        }
        catch (RejectedExecutionException e) {
            serverStats.onRequestEnded(httpExchange.request);
            connectionStats.onRequestEnded(httpExchange.request);
            log.warn("Could not service " + muRequest + " because the thread pool is full so sending a 503");
            throw new InvalidHttpRequestException(503, "503 Service Unavailable");
        }
        return httpExchange;
    }

    static String getRelativeUrl(String nettyUri) throws InvalidHttpRequestException, RedirectException {
        try {
            URI requestUri = new URI(nettyUri).normalize();
            if (requestUri.getScheme() == null && requestUri.getHost() != null) {
                throw new RedirectException(new URI(nettyUri.substring(1)).normalize());
            }
            String s = requestUri.getRawPath();
            s = Mutils.nullOrEmpty(s) ? "/" : s.replace("%7E", "~").replace("%5F", "_").replace("%2E", ".").replace("%2D", "-");
            String q = requestUri.getRawQuery();
            if (q != null) {
                s = s + "?" + q;
            }
            return s;
        }
        catch (RedirectException re) {
            throw re;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Invalid request URL " + nettyUri);
            }
            throw new InvalidHttpRequestException(400, "400 Bad Request");
        }
    }

    static Method getMethod(HttpMethod nettyMethod) throws InvalidHttpRequestException {
        Method method;
        try {
            method = Method.fromNetty(nettyMethod);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidHttpRequestException(405, "405 Method Not Allowed");
        }
        return method;
    }

    private static void throwIfInvalid(ServerSettings settings, ChannelHandlerContext ctx, HttpRequest nettyRequest) throws InvalidHttpRequestException {
        long cld;
        if (nettyRequest.decoderResult().isFailure()) {
            Throwable cause = nettyRequest.decoderResult().cause();
            if (cause instanceof TooLongFrameException) {
                if (cause.getMessage().contains("header is larger")) {
                    throw new InvalidHttpRequestException(431, "431 Request Header Fields Too Large");
                }
                if (cause.getMessage().contains("line is larger")) {
                    throw new InvalidHttpRequestException(414, "414 Request-URI Too Long");
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Invalid http request received", cause);
            }
            throw new InvalidHttpRequestException(500, "Invalid HTTP request received");
        }
        String contentLenDecl = nettyRequest.headers().get("Content-Length");
        if (HttpUtil.is100ContinueExpected((HttpMessage)nettyRequest)) {
            long requestBodyLen;
            long l = requestBodyLen = contentLenDecl == null ? -1L : Long.parseLong(contentLenDecl, 10);
            if (requestBodyLen <= settings.maxRequestSize) {
                ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
            } else {
                throw new InvalidHttpRequestException(417, "417 Expectation Failed - request too large");
            }
        }
        if (!nettyRequest.headers().contains((CharSequence)HttpHeaderNames.HOST)) {
            throw new InvalidHttpRequestException(400, "400 Bad Request - no Host header");
        }
        if (contentLenDecl != null && (cld = Long.parseLong(contentLenDecl, 10)) > settings.maxRequestSize) {
            throw new InvalidHttpRequestException(413, "413 Payload Too Large");
        }
    }

    void fireException(Throwable cause) {
        this.ctx.pipeline().fireUserEventTriggered((Object)new MuExceptionFiredEvent(this, this.streamId, cause));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onException(ChannelHandlerContext ctx, Throwable cause) {
        assert (this.inLoop()) : "onException not called from nio event loop";
        if (this.state.endState()) {
            log.warn("Got exception after state is " + (Object)((Object)this.state));
            return true;
        }
        boolean streamUnrecoverable = true;
        try {
            if (!this.response.hasStartedSendingData()) {
                int status;
                WebApplicationException wae;
                if (this.request.requestState() != RequestState.ERRORED) {
                    streamUnrecoverable = false;
                }
                if (cause instanceof WebApplicationException) {
                    wae = (WebApplicationException)cause;
                } else {
                    String errorID = "ERR-" + UUID.randomUUID();
                    log.info("Sending a 500 to the client with ErrorID=" + errorID + " for " + this.request, cause);
                    wae = new InternalServerErrorException("Oops! An unexpected error occurred. The ErrorID=" + errorID);
                }
                Response exResp = wae.getResponse();
                if (exResp == null) {
                    exResp = Response.serverError().build();
                }
                if ((status = exResp.getStatus()) == 429 || status == 408 || status == 413) {
                    streamUnrecoverable = true;
                }
                this.response.status(status);
                boolean isHttp1 = this.request.protocol().equals("HTTP/1.1");
                MuRuntimeDelegate.writeResponseHeaders(this.request.uri(), exResp, this.response, isHttp1);
                if (streamUnrecoverable && isHttp1) {
                    this.response.headers().set(HeaderNames.CONNECTION, (Object)HeaderValues.CLOSE);
                }
                this.response.contentType(ContentTypes.TEXT_HTML_UTF8);
                String message = wae.getMessage();
                message = exceptionMessageMap.getOrDefault(message, message);
                this.response.writeOnLoop("<h1>" + status + " " + exResp.getStatusInfo().getReasonPhrase() + "</h1><p>" + Mutils.htmlEncode(message) + "</p>").addListener(f -> {
                    ResponseState state = f.isSuccess() ? ResponseState.FULL_SENT : ResponseState.ERRORED;
                    this.response.outputState((Future<? super Void>)f, state);
                });
            } else {
                log.info(cause.getClass().getName() + " while handling " + this.request + " - note a " + this.response.status + " was already sent and the client may have received an incomplete response. Exception was " + cause.getMessage());
            }
        }
        catch (Exception e) {
            log.warn("Error while processing processing " + cause + " for " + this.request, (Throwable)e);
        }
        finally {
            if (streamUnrecoverable) {
                this.response.onCancelled(ResponseState.ERRORED);
                this.request.onCancelled(ResponseState.ERRORED, cause);
            }
        }
        return streamUnrecoverable;
    }

    @Override
    public void onConnectionEnded(ChannelHandlerContext ctx) {
        if (!this.response.outputState().endState()) {
            this.onCancelled(ResponseState.CLIENT_DISCONNECTED);
        }
        if (!this.request.requestState().endState()) {
            this.request.onCancelled(ResponseState.CLIENT_DISCONNECTED, new ClientDisconnectedException());
        }
    }

    public long startTime() {
        return this.startTime;
    }

    static {
        MuRuntimeDelegate.ensureSet();
        exceptionMessageMap.put(new NotFoundException().getMessage(), "This page is not available. Sorry about that.");
        log = LoggerFactory.getLogger(HttpExchange.class);
    }
}

