/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.HttpConnection;
import io.muserver.HttpsConfigBuilder;
import io.muserver.MuException;
import io.muserver.MuServer;
import io.muserver.MuStats;
import io.muserver.MuStatsImpl;
import io.muserver.Mutils;
import io.muserver.RateLimiter;
import io.muserver.RateLimiterImpl;
import io.muserver.SSLInfo;
import io.muserver.SSLInfoImpl;
import io.muserver.ServerSettings;
import io.muserver.SslContextProvider;
import io.muserver.UnhandledExceptionHandler;
import io.netty.handler.ssl.SslContext;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

class MuServerImpl
implements MuServer {
    private URI httpUri;
    private URI httpsUri;
    private Runnable shutdown;
    final MuStatsImpl stats;
    private InetSocketAddress address;
    private SslContextProvider sslContextProvider;
    private final boolean http2Enabled;
    private final ServerSettings settings;
    private final Set<HttpConnection> connections = ConcurrentHashMap.newKeySet();
    final UnhandledExceptionHandler unhandledExceptionHandler;

    void onStarted(URI httpUri, URI httpsUri, Runnable shutdown, InetSocketAddress address, SslContextProvider sslContextProvider) {
        this.address = address;
        this.sslContextProvider = sslContextProvider;
        if (httpUri == null && httpsUri == null) {
            throw new IllegalArgumentException("One of httpUri and httpsUri must not be null");
        }
        this.httpUri = httpUri;
        this.httpsUri = httpsUri;
        this.shutdown = shutdown;
    }

    MuServerImpl(MuStatsImpl stats, boolean http2Enabled, ServerSettings settings, UnhandledExceptionHandler unhandledExceptionHandler) {
        this.stats = stats;
        this.http2Enabled = http2Enabled;
        this.settings = settings;
        this.unhandledExceptionHandler = unhandledExceptionHandler;
    }

    @Override
    public void stop() {
        this.shutdown.run();
    }

    @Override
    public URI uri() {
        return this.httpsUri != null ? this.httpsUri : this.httpUri;
    }

    @Override
    public URI httpUri() {
        return this.httpUri;
    }

    @Override
    public URI httpsUri() {
        return this.httpsUri;
    }

    @Override
    public MuStats stats() {
        return this.stats;
    }

    @Override
    public Set<HttpConnection> activeConnections() {
        return Collections.unmodifiableSet(this.connections);
    }

    @Override
    public InetSocketAddress address() {
        return this.address;
    }

    @Override
    public long minimumGzipSize() {
        return this.settings.minimumGzipSize;
    }

    @Override
    public int maxRequestHeadersSize() {
        return this.settings.maxHeadersSize;
    }

    @Override
    public long requestIdleTimeoutMillis() {
        return this.settings.requestReadTimeoutMillis;
    }

    @Override
    public long maxRequestSize() {
        return this.settings.maxRequestSize;
    }

    @Override
    public int maxUrlSize() {
        return this.settings.maxUrlSize;
    }

    @Override
    public boolean gzipEnabled() {
        return this.settings.gzipEnabled;
    }

    @Override
    public Set<String> mimeTypesToGzip() {
        return this.settings.mimeTypesToGzip;
    }

    @Override
    public void changeHttpsConfig(HttpsConfigBuilder newHttpsConfig) {
        Mutils.notNull("newSSLContext", newHttpsConfig);
        try {
            SslContext nettySslContext = newHttpsConfig.toNettySslContext(this.http2Enabled);
            this.sslContextProvider.set(nettySslContext);
            ((SSLInfoImpl)this.sslContextProvider.sslInfo()).setHttpsUri(this.httpsUri);
        }
        catch (Exception e) {
            throw new MuException("Error while changing SSL Certificate. The old one will still be used.", e);
        }
    }

    @Override
    public SSLInfo sslInfo() {
        return this.sslContextProvider == null ? null : this.sslContextProvider.sslInfo();
    }

    @Override
    public List<RateLimiter> rateLimiters() {
        List<RateLimiterImpl> rateLimiters = this.settings.rateLimiters;
        return rateLimiters == null ? Collections.emptyList() : rateLimiters.stream().map(RateLimiter.class::cast).collect(Collectors.toList());
    }

    public String toString() {
        return "MuServerImpl{httpUri=" + this.httpUri + ", httpsUri=" + this.httpsUri + ", stats=" + this.stats + ", address=" + this.address + '}';
    }

    void onConnectionStarted(HttpConnection connection) {
        this.connections.add(connection);
    }

    void onConnectionEnded(HttpConnection connection) {
        this.connections.remove(connection);
    }

    ServerSettings settings() {
        return this.settings;
    }
}

