/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.Mutils;
import io.muserver.UploadedFile;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.FileUpload;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

class MuUploadedFile
implements UploadedFile {
    private final FileUpload fu;
    private File file;

    MuUploadedFile(FileUpload fileUpload) {
        this.fu = fileUpload;
    }

    @Override
    public File asFile() throws IOException {
        if (this.file == null) {
            if (this.fu.isInMemory()) {
                File dir = DiskFileUpload.baseDirectory == null ? null : new File(DiskFileUpload.baseDirectory);
                File tmpFile = File.createTempFile("mufu", ".tmp", dir);
                tmpFile.deleteOnExit();
                this.fu.renameTo(tmpFile);
                this.file = tmpFile;
            } else {
                this.file = this.fu.getFile();
            }
        }
        return this.file;
    }

    @Override
    public String asString() throws IOException {
        return this.fu.getString(StandardCharsets.UTF_8);
    }

    @Override
    public byte[] asBytes() throws IOException {
        return this.fu.get();
    }

    @Override
    public String contentType() {
        return this.fu.getContentType();
    }

    @Override
    public String filename() {
        String n = this.fu.getFilename();
        int i = n.lastIndexOf(47);
        if (i > -1) {
            n = n.substring(i + 1);
        }
        if ((i = n.lastIndexOf(92)) > -1) {
            n = n.substring(i + 1);
        }
        return n;
    }

    @Override
    public String extension() {
        String n = this.filename();
        int i = n.lastIndexOf(46);
        if (i > -1) {
            return n.substring(i + 1);
        }
        return "";
    }

    @Override
    public void saveTo(File dest) throws IOException {
        Mutils.notNull("dest", dest);
        dest.getParentFile().mkdirs();
        if (!this.fu.renameTo(dest)) {
            throw new IOException("Failed to save file to " + dest.getCanonicalPath());
        }
        this.file = dest;
    }

    @Override
    public long size() {
        return this.fu.length();
    }

    @Override
    public InputStream asStream() throws IOException {
        if (this.fu.isInMemory()) {
            return new ByteArrayInputStream(this.fu.get());
        }
        return new FileInputStream(this.fu.getFile());
    }
}

