/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.ClientDisconnectedException;
import io.muserver.DoneCallback;
import io.muserver.Exchange;
import io.muserver.HttpConnection;
import io.muserver.MuExceptionFiredEvent;
import io.muserver.MuWebSocket;
import io.muserver.MuWebSocketSession;
import io.muserver.UnexpectedMessageException;
import io.muserver.WebsocketSessionState;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MuWebSocketSessionImpl
implements MuWebSocketSession,
Exchange {
    static final byte[] PING_BYTES = new byte[]{109, 117};
    private static final Logger log = LoggerFactory.getLogger(MuWebSocketSessionImpl.class);
    private final ChannelHandlerContext ctx;
    final MuWebSocket muWebSocket;
    private final HttpConnection connection;
    private volatile WebsocketSessionState state = WebsocketSessionState.NOT_STARTED;
    private volatile ContinuationState receivingState = ContinuationState.NONE;
    private volatile ContinuationState sendingState = ContinuationState.NONE;

    MuWebSocketSessionImpl(ChannelHandlerContext ctx, MuWebSocket muWebSocket, HttpConnection connection) {
        this.ctx = ctx;
        this.muWebSocket = muWebSocket;
        this.connection = connection;
    }

    @Override
    public void sendText(String message, DoneCallback doneCallback) {
        this.sendText(message, true, doneCallback);
    }

    @Override
    public void sendText(String message, boolean isLastFragment, DoneCallback doneCallback) {
        TextWebSocketFrame frame;
        if (this.sendingState == ContinuationState.BINARY) {
            throw new IllegalStateException("Cannot send a text message while a partial binary message is being sent");
        }
        if (this.sendingState == ContinuationState.NONE) {
            frame = new TextWebSocketFrame(isLastFragment, 0, message);
            if (!isLastFragment) {
                this.sendingState = ContinuationState.TEXT;
            }
        } else {
            frame = new ContinuationWebSocketFrame(isLastFragment, 0, message);
            if (isLastFragment) {
                this.sendingState = ContinuationState.NONE;
            }
        }
        this.writeAsync((WebSocketFrame)frame, doneCallback);
    }

    @Override
    public void sendBinary(ByteBuffer message, DoneCallback doneCallback) {
        this.sendBinary(message, true, doneCallback);
    }

    @Override
    public void sendBinary(ByteBuffer message, boolean isLastFragment, DoneCallback doneCallback) {
        BinaryWebSocketFrame frame;
        if (this.sendingState == ContinuationState.TEXT) {
            throw new IllegalStateException("Cannot send a binary message while a partial text message is being sent");
        }
        ByteBuf bb = Unpooled.wrappedBuffer((ByteBuffer)message);
        if (this.sendingState == ContinuationState.NONE) {
            frame = new BinaryWebSocketFrame(isLastFragment, 0, bb);
            if (!isLastFragment) {
                this.sendingState = ContinuationState.BINARY;
            }
        } else {
            frame = new ContinuationWebSocketFrame(isLastFragment, 0, bb);
            if (isLastFragment) {
                this.sendingState = ContinuationState.NONE;
            }
        }
        this.writeAsync((WebSocketFrame)frame, doneCallback);
    }

    @Override
    public void sendPing(ByteBuffer payload, DoneCallback doneCallback) {
        ByteBuf bb = Unpooled.wrappedBuffer((ByteBuffer)payload);
        this.writeAsync((WebSocketFrame)new PingWebSocketFrame(bb), doneCallback);
    }

    @Override
    public void sendPong(ByteBuffer payload, DoneCallback doneCallback) {
        ByteBuf bb = Unpooled.wrappedBuffer((ByteBuffer)payload);
        this.writeAsync((WebSocketFrame)new PongWebSocketFrame(bb), doneCallback);
    }

    @Override
    public void close() {
        this.close(1000, "Server");
    }

    @Override
    public void close(int statusCode, String reason) {
        WebsocketSessionState endState;
        if (this.state.endState()) {
            throw new IllegalArgumentException("Cannot close a websocket when the state is " + (Object)((Object)this.state));
        }
        if (statusCode < 1000 || statusCode >= 5000) {
            throw new IllegalArgumentException("Web socket closure codes must be between 1000 and 4999 (inclusive)");
        }
        if (this.state == WebsocketSessionState.CLIENT_CLOSING) {
            endState = WebsocketSessionState.CLIENT_CLOSED;
        } else {
            this.setState(WebsocketSessionState.SERVER_CLOSING);
            endState = statusCode == 1001 && WebsocketSessionState.TIMED_OUT.name().equals(reason) ? WebsocketSessionState.TIMED_OUT : (statusCode > 1000 && WebsocketSessionState.ERRORED.name().equals(reason) ? WebsocketSessionState.ERRORED : WebsocketSessionState.SERVER_CLOSED);
        }
        CloseWebSocketFrame closeFrame = new CloseWebSocketFrame(statusCode, reason);
        this.writeAsync((WebSocketFrame)closeFrame, error -> this.ctx.close().addListener(future -> this.setState(future.isSuccess() ? endState : WebsocketSessionState.ERRORED)));
    }

    void setState(WebsocketSessionState newState) {
        this.state = newState;
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)this.ctx.channel().remoteAddress();
    }

    @Override
    public WebsocketSessionState state() {
        return this.state;
    }

    private void writeAsync(WebSocketFrame msg, DoneCallback doneCallback) {
        if (this.state.endState() || this.state.closing() && !(msg instanceof CloseWebSocketFrame)) {
            try {
                doneCallback.onComplete(new IllegalStateException("Writes are not allowed as the socket has already been closed"));
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.ctx.channel().writeAndFlush((Object)msg).addListener((GenericFutureListener)((ChannelFutureListener)future1 -> {
            try {
                if (future1.isSuccess()) {
                    doneCallback.onComplete(null);
                } else {
                    doneCallback.onComplete(future1.cause());
                }
            }
            catch (Throwable e) {
                log.warn("Unhandled exception from write callback", e);
                this.close(1011, "Server error");
            }
        }));
    }

    @Override
    public void onMessage(ChannelHandlerContext ctx, Object msg, DoneCallback doneCallback) throws UnexpectedMessageException {
        if (!(msg instanceof WebSocketFrame)) {
            if (msg instanceof HttpContent) {
                return;
            }
            throw new UnexpectedMessageException(this, msg);
        }
        WebSocketFrame frame = (WebSocketFrame)msg;
        if (this.state.endState() || this.state.closing()) {
            return;
        }
        MuWebSocket muWebSocket = this.muWebSocket;
        DoneCallback onComplete = error -> {
            if (error != null) {
                this.handleWebsocketError(ctx, muWebSocket, error);
            }
            doneCallback.onComplete(error);
        };
        ByteBuf retained = null;
        try {
            if (frame instanceof TextWebSocketFrame || this.receivingState == ContinuationState.TEXT && frame instanceof ContinuationWebSocketFrame) {
                this.receivingState = frame.isFinalFragment() ? ContinuationState.NONE : ContinuationState.TEXT;
                String content = frame.content().toString(StandardCharsets.UTF_8);
                muWebSocket.onText(content, frame.isFinalFragment(), onComplete);
            } else if (frame instanceof BinaryWebSocketFrame || this.receivingState == ContinuationState.BINARY && frame instanceof ContinuationWebSocketFrame) {
                this.receivingState = frame.isFinalFragment() ? ContinuationState.NONE : ContinuationState.BINARY;
                ByteBuf content = frame.content();
                retained = content.retain();
                muWebSocket.onBinary(content.nioBuffer(), frame.isFinalFragment(), onComplete, () -> ((ByteBuf)content).release());
            } else if (frame instanceof PingWebSocketFrame) {
                ByteBuf content = frame.content();
                retained = content.retain();
                muWebSocket.onPing(content.nioBuffer(), error -> {
                    content.release();
                    onComplete.onComplete(error);
                });
            } else if (frame instanceof PongWebSocketFrame) {
                ByteBuf content = frame.content();
                retained = content.retain();
                muWebSocket.onPong(content.nioBuffer(), error -> {
                    content.release();
                    onComplete.onComplete(error);
                });
            } else if (frame instanceof CloseWebSocketFrame) {
                CloseWebSocketFrame cwsf = (CloseWebSocketFrame)frame;
                if (this.state == WebsocketSessionState.SERVER_CLOSING) {
                    ctx.close().addListener(future -> this.setState(WebsocketSessionState.SERVER_CLOSED));
                } else {
                    this.setState(WebsocketSessionState.CLIENT_CLOSING);
                    muWebSocket.onClientClosed(cwsf.statusCode(), cwsf.reasonText());
                }
                onComplete.onComplete(null);
            }
        }
        catch (Throwable e) {
            if (retained != null) {
                retained.release();
            }
            this.handleWebsocketError(ctx, muWebSocket, e);
        }
    }

    @Override
    public void onIdleTimeout(ChannelHandlerContext ctx, IdleStateEvent ise) {
        if (ise.state() == IdleState.READER_IDLE) {
            try {
                this.muWebSocket.onError(new TimeoutException("No messages received on websocket"));
            }
            catch (Exception e) {
                log.warn("Error while processing idle timeout", (Throwable)e);
                ctx.close();
            }
        } else {
            this.sendPing(ByteBuffer.wrap(PING_BYTES), DoneCallback.NoOp);
        }
    }

    @Override
    public boolean onException(ChannelHandlerContext ctx, Throwable cause) {
        if (!this.state.endState()) {
            try {
                this.muWebSocket.onError(cause);
                return false;
            }
            catch (Exception e) {
                return true;
            }
        }
        return true;
    }

    @Override
    public void onConnectionEnded(ChannelHandlerContext ctx) {
        if (!this.state.endState()) {
            this.setState(WebsocketSessionState.DISCONNECTED);
            try {
                this.muWebSocket.onError(new ClientDisconnectedException());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void handleWebsocketError(ChannelHandlerContext ctx, MuWebSocket muWebSocket, Throwable e) {
        if (!this.state.endState()) {
            try {
                muWebSocket.onError(e);
            }
            catch (Exception ex) {
                log.warn("Exception thrown by " + muWebSocket.getClass() + "#onError so will close connection", (Throwable)ex);
                ctx.close();
            }
        }
    }

    @Override
    public HttpConnection connection() {
        return this.connection;
    }

    @Override
    public void onUpgradeComplete(ChannelHandlerContext ctx) {
        this.setState(WebsocketSessionState.OPEN);
        try {
            this.muWebSocket.onConnect(this);
        }
        catch (Exception e) {
            log.warn("Error thrown by websocket onComplete handler", (Throwable)e);
            ctx.fireUserEventTriggered((Object)new MuExceptionFiredEvent(this, -1, e));
        }
    }

    static enum ContinuationState {
        NONE,
        TEXT,
        BINARY;

    }
}

