/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.MuException;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Stream;

public class Mutils {
    public static final String NEWLINE = String.format("%n", new Object[0]);
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8").replace("+", "%20").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            throw new MuException("Error encoding " + value, e);
        }
    }

    public static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MuException("Error encoding " + value, e);
        }
    }

    private Mutils() {
    }

    public static void copy(InputStream from, OutputStream to, int bufferSize) throws IOException {
        int read;
        byte[] buffer = new byte[bufferSize];
        while ((read = from.read(buffer)) > -1) {
            if (read <= 0) continue;
            to.write(buffer, 0, read);
        }
    }

    public static byte[] toByteArray(InputStream source, int bufferSize) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Mutils.copy(source, baos, bufferSize);
        source.close();
        return baos.toByteArray();
    }

    public static boolean nullOrEmpty(String val) {
        return val == null || val.length() == 0;
    }

    public static boolean hasValue(String val) {
        return !Mutils.nullOrEmpty(val);
    }

    public static String join(String one, String sep, String two) {
        one = one == null ? "" : one;
        two = two == null ? "" : two;
        boolean oneEnds = one.endsWith(sep);
        boolean twoStarts = two.startsWith(sep);
        if (oneEnds && twoStarts) {
            return one + two.substring(sep.length());
        }
        if (oneEnds || twoStarts) {
            return one + two;
        }
        return one + sep + two;
    }

    public static String trim(String value, String toTrim) {
        int len = toTrim.length();
        while (value.startsWith(toTrim)) {
            value = value.substring(len);
        }
        while (value.endsWith(toTrim)) {
            value = value.substring(0, value.length() - len);
        }
        return value;
    }

    public static void notNull(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
    }

    public static String fullPath(File file) {
        Mutils.notNull("file", file);
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    public static String toHttpDate(Date date) {
        Mutils.notNull("date", date);
        return DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneOffset.UTC).format(Instant.ofEpochMilli(date.getTime()));
    }

    public static Date fromHttpDate(String date) throws DateTimeParseException {
        Mutils.notNull("date", date);
        return new Date(DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneOffset.UTC).parse((CharSequence)date, Instant::from).toEpochMilli());
    }

    public static String htmlEncode(String value) {
        if (value == null) {
            return "";
        }
        return value.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#x27;").replace("/", "&#x2F;");
    }

    public static <T> T coalesce(T ... values) {
        return Stream.of(values).filter(Objects::nonNull).findFirst().orElse(null);
    }

    static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static ByteBuffer toByteBuffer(String text) {
        Mutils.notNull("text", text);
        if (text.isEmpty()) {
            return EMPTY_BUFFER;
        }
        return ByteBuffer.wrap(text.getBytes(StandardCharsets.UTF_8));
    }

    public static String pathAndQuery(URI uri) {
        String pathAndQuery = uri.getRawPath();
        String rawQuery = uri.getRawQuery();
        if (rawQuery != null) {
            pathAndQuery = pathAndQuery + "?" + rawQuery;
        }
        return pathAndQuery;
    }
}

